% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_top_expressed_genes.R
\name{get_top_expressed_genes}
\alias{get_top_expressed_genes}
\title{Get Top Expressed Genes}
\usage{
get_top_expressed_genes(
  tissueSiteDetailId,
  datasetId = "gtex_v8",
  filterMtGene = TRUE,
  page = 0,
  itemsPerPage = 250
)
}
\arguments{
\item{tissueSiteDetailId}{String. The ID of the tissue of interest. Can be a
GTEx specific ID (e.g. "Whole_Blood"; use \code{\link[=get_tissue_site_detail]{get_tissue_site_detail()}}
to see valid values) or an Ontology ID.}

\item{datasetId}{String. Unique identifier of a dataset. Usually includes a
data source and data release. Options: "gtex_v8", "gtex_snrnaseq_pilot".}

\item{filterMtGene}{Logical. Exclude mitochondrial genes.}

\item{page}{Integer (default = 0).}

\item{itemsPerPage}{Integer (default = 250).}
}
\value{
A tibble.
}
\description{
Find top expressed genes for a specified tissue.
\itemize{
\item Returns top expressed genes for a specified tissue in a dataset, sorted by median expression.
\item When the optional parameter filterMtGene is set to true, mitochondrial genes will be excluded from the results.
By default, this service queries the latest GTEx release.
}

\href{https://gtexportal.org/api/v2/redoc#tag/Expression-Data-Endpoints/operation/get_top_expressed_genes_api_v2_expression_topExpressedGene_get}{GTEx Portal API documentation}
}
\examples{
\dontrun{
get_top_expressed_genes(tissueSiteDetailId = "Artery_Aorta")
}
}
\seealso{
Other Expression Data Endpoints: 
\code{\link{get_clustered_median_exon_expression}()},
\code{\link{get_clustered_median_gene_expression}()},
\code{\link{get_clustered_median_junction_expression}()},
\code{\link{get_clustered_median_transcript_expression}()},
\code{\link{get_expression_pca}()},
\code{\link{get_gene_expression}()},
\code{\link{get_median_exon_expression}()},
\code{\link{get_median_gene_expression}()},
\code{\link{get_median_junction_expression}()},
\code{\link{get_median_transcript_expression}()},
\code{\link{get_single_nucleus_gex}()},
\code{\link{get_single_nucleus_gex_summary}()}
}
\concept{Expression Data Endpoints}
