% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtfs2gps.R
\name{gtfs2gps}
\alias{gtfs2gps}
\title{Convert GTFS to GPS-like data given a spatial resolution}
\usage{
gtfs2gps(
  gtfs_data,
  spatial_resolution = 50,
  parallel = FALSE,
  strategy = "multiprocess",
  progress = TRUE,
  filepath = NULL,
  continue = FALSE
)
}
\arguments{
\item{gtfs_data}{A path to a GTFS file to be converted to GPS, or a GTFS data
represented as a list of data.tables.}

\item{spatial_resolution}{The spatial resolution in meters. Default is 50m.}

\item{parallel}{Decides whether the function should run in parallel. Defaults to FALSE.
When TRUE, it will use all cores available minus one.}

\item{strategy}{Name of evaluation function to use in future parallel processing. Defaults to 
"multiprocess", i.e. if multicore evaluation is supported, that will be used, otherwise
 multisession evaluation will be used. Fore details, check ?future::plan().}

\item{progress}{Show a progress bar. Default is TRUE.}

\item{filepath}{Output file path. As default, the output is returned in R.
When this argument is set, each route is saved into a file within filepath,
with the name equals to its id. In this case, no output is returned.}

\item{continue}{Argument that can be used only with filepath. When TRUE, it
skips processing the shape identifiers that were already saved into files.
It is useful to continue processing a GTFS file that was stopped for some
reason. Default value is FALSE.}
}
\value{
A data.table, where each row represents a GPS point. The following columns are
returned (units of measurement in parenthesis): dist and cumdist (meters), cumtime (seconds),
shape_pt_lon and shape_pt_lat (degrees), speed (km/h), departure_time (hh:mm:ss), .
}
\description{
Convert GTFS data to GPS format by sampling points using a
spatial resolution. This function creates additional points in order to
guarantee that two points in a same trip will have at most a given
distance, indicated as a spatial resolution.
}
\examples{
library(dplyr)
poa <- read_gtfs(system.file("extdata/poa.zip", package="gtfs2gps"))
subset <- filter_by_shape_id(poa, "T2-1") \%>\%
  filter_single_trip()

poa_gps <- gtfs2gps(subset)
}
