% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bold_p.R
\name{bold_p.tbl_regression}
\alias{bold_p.tbl_regression}
\title{Bold significant p-values or q-values}
\usage{
\method{bold_p}{tbl_regression}(x, t = 0.05, ...)
}
\arguments{
\item{x}{Object created using \link{tbl_regression} function}

\item{t}{Threshold below which values will be bold. Default is 0.05.}

\item{...}{Not used}
}
\value{
A \code{tbl_regression} object
}
\description{
Bold values below a chosen threshold (e.g. <0.05)
in \link{tbl_regression} tables.
}
\section{Example Output}{

\if{html}{\figure{tbl_lm_bold_p_ex.png}{options: width=50\%}}
}

\examples{
tbl_lm_bold_p_ex <-
  glm(response ~ trt + grade, trial, family = binomial(link = "logit")) \%>\%
  tbl_regression(exponentiate = TRUE) \%>\%
  bold_p()
}
\seealso{
Other tbl_regression tools: 
\code{\link{add_global_p.tbl_regression}()},
\code{\link{add_nevent.tbl_regression}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{bold_p.tbl_stack}()},
\code{\link{inline_text.tbl_regression}()},
\code{\link{modify_header}()},
\code{\link{sort_p.tbl_regression}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_regression}()},
\code{\link{tbl_stack}()}
}
\author{
Daniel D. Sjoberg, Esther Drill
}
\concept{tbl_regression tools}
