% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_percent.R
\name{style_percent}
\alias{style_percent}
\title{Style percentages to be displayed in tables or text}
\usage{
style_percent(x, symbol = FALSE)
}
\arguments{
\item{x}{numeric vector of percentages}

\item{symbol}{Logical indicator to include percent symbol in output.
Default is \code{FALSE}.}
}
\value{
A character vector of styled percentages
}
\description{
Style percentages to be displayed in tables or text
}
\examples{
percent_vals <- c(-1, 0, 0.0001, 0.005, 0.01, 0.10, 0.45356, 0.99, 1.45)
style_percent(percent_vals)
style_percent(percent_vals, symbol = TRUE)
}
\seealso{
See Table Gallery \href{http://www.danieldsjoberg.com/gtsummary/articles/gallery.html}{vignette} for example

Other style tools: 
\code{\link{style_pvalue}()},
\code{\link{style_ratio}()},
\code{\link{style_sigfig}()}
}
\author{
Daniel D. Sjoberg
}
\concept{style tools}
