% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_regression_methods.R
\name{tbl_regression_methods}
\alias{tbl_regression_methods}
\alias{tbl_regression.survreg}
\alias{tbl_regression.mira}
\alias{tbl_regression.mipo}
\alias{tbl_regression.lmerMod}
\alias{tbl_regression.glmerMod}
\alias{tbl_regression.glmmTMB}
\alias{tbl_regression.glmmadmb}
\alias{tbl_regression.stanreg}
\alias{tbl_regression.multinom}
\title{Methods for tbl_regression}
\usage{
\method{tbl_regression}{survreg}(
  x,
  tidy_fun = function(x, ...) broom::tidy(x, ...) \%>\% dplyr::filter(.data$term !=
    "Log(scale)"),
  ...
)

\method{tbl_regression}{mira}(x, tidy_fun = pool_and_tidy_mice, ...)

\method{tbl_regression}{mipo}(x, ...)

\method{tbl_regression}{lmerMod}(
  x,
  tidy_fun = function(x, ...) broom.mixed::tidy(x, ..., effects = "fixed"),
  ...
)

\method{tbl_regression}{glmerMod}(
  x,
  tidy_fun = function(x, ...) broom.mixed::tidy(x, ..., effects = "fixed"),
  ...
)

\method{tbl_regression}{glmmTMB}(
  x,
  tidy_fun = function(x, ...) broom.mixed::tidy(x, ..., effects = "fixed"),
  ...
)

\method{tbl_regression}{glmmadmb}(
  x,
  tidy_fun = function(x, ...) broom.mixed::tidy(x, ..., effects = "fixed"),
  ...
)

\method{tbl_regression}{stanreg}(
  x,
  tidy_fun = function(x, ...) broom.mixed::tidy(x, ..., effects = "fixed"),
  ...
)

\method{tbl_regression}{multinom}(x, ...)
}
\arguments{
\item{x}{Regression model object}

\item{tidy_fun}{Option to specify a particular tidier function if the
model is not a \link[=vetted_models]{vetted model} or you need to implement a
custom method. Default is \code{NULL}}

\item{...}{arguments passed to \code{tbl_regression.default()}}
}
\description{
Most regression models are handled by \code{\link[=tbl_regression.default]{tbl_regression.default()}},
which uses \code{\link[broom:reexports]{broom::tidy()}} to perform initial tidying of results. There are,
however, some model types that have modified default printing behavior.
Those methods are listed below.
}
\section{Methods}{


The default method for \code{tbl_regression()} model summary uses \code{broom::tidy(x)}
to perform the initial tidying of the model object. There are, however,
a few models that use \link[=tbl_regression_methods]{modifications}.
\itemize{
\item \code{"survreg"}: The scale parameter is removed, \code{broom::tidy(x) \%>\% dplyr::filter(term != "Log(scale)")}
\item \code{"multinom"}: This multinomial outcome is complex, with one line per covariate per outcome (less the reference group)
\item \code{"lmerMod"}, \code{"glmerMod"}, \code{"glmmTMB"}, \code{"glmmadmb"}, \code{"stanreg"}: These mixed effects
models use \code{broom.mixed::tidy(x, effects = "fixed")}. Specify \code{tidy_fun = broom.mixed::tidy}
to print the random components.
}
}

