% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_n.R
\name{add_n.tbl_survfit}
\alias{add_n.tbl_survfit}
\title{Add column with number of observations}
\usage{
\method{add_n}{tbl_survfit}(x, ...)
}
\arguments{
\item{x}{object of class "\code{tbl_survfit}"}

\item{...}{Not used}
}
\description{
\lifecycle{maturing}
For each \code{survfit()} object summarized with \code{tbl_survfit()} this function
will add the total number of observations in a new column.
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{add_n.tbl_survfit_ex1.png}{options: width=64\%}}
}

\examples{
\dontshow{if (broom.helpers::.assert_package("survival", pkg_search = "gtsummary", boolean = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(survival)
fit1 <- survfit(Surv(ttdeath, death) ~ 1, trial)
fit2 <- survfit(Surv(ttdeath, death) ~ trt, trial)

# Example 1 ----------------------------------
add_n.tbl_survfit_ex1 <-
  list(fit1, fit2) \%>\%
  tbl_survfit(times = c(12, 24)) \%>\%
  add_n()
\dontshow{\}) # examplesIf}
}
\seealso{
Review \link[=syntax]{list, formula, and selector syntax} used throughout gtsummary

Other tbl_survfit tools: 
\code{\link{add_nevent.tbl_survfit}()},
\code{\link{add_p.tbl_survfit}()},
\code{\link{modify}},
\code{\link{tbl_merge}()},
\code{\link{tbl_split}()},
\code{\link{tbl_stack}()},
\code{\link{tbl_strata}()},
\code{\link{tbl_survfit}()}
}
\concept{tbl_survfit tools}
