% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_kable_extra.R
\name{as_kable_extra}
\alias{as_kable_extra}
\title{Convert gtsummary object to a kableExtra object}
\usage{
as_kable_extra(
  x,
  escape = FALSE,
  format = NULL,
  ...,
  include = everything(),
  addtl_fmt = TRUE,
  return_calls = FALSE
)
}
\arguments{
\item{x}{Object created by a function from the gtsummary package
(e.g. \link{tbl_summary} or \link{tbl_regression})}

\item{format, escape, ...}{arguments passed to \code{knitr::kable()}. Default is
\code{escape = FALSE}, and the format is auto-detected.}

\item{include}{Commands to include in output. Input may be a vector of
quoted or unquoted names. tidyselect and gtsummary select helper
functions are also accepted.
Default is \code{everything()}.}

\item{addtl_fmt}{logical indicating whether to include additional formatting.
Default is \code{TRUE}. This is primarily used to escape special characters,
convert markdown to LaTeX, and remove line breaks from the footnote.}

\item{return_calls}{Logical. Default is \code{FALSE}. If \code{TRUE}, the calls are returned
as a list of expressions.}
}
\value{
A {kableExtra} table
}
\description{
Function converts a gtsummary object to a knitr_kable + kableExtra object.
This allows the customized formatting available via \code{knitr::kable()}
and {kableExtra}; \code{as_kable_extra()} supports arguments in \code{knitr::kable()}.
\code{as_kable_extra()} output via gtsummary supports
bold and italic cells for table bodies. Users
are encouraged to leverage \code{as_kable_extra()} for enhanced pdf printing; for html
output options there is better support via \code{as_gt()}.
}
\section{PDF/LaTeX}{


This section shows options intended for use with \code{output: pdf_document} in yaml of \code{.Rmd}.

When the default values of \code{as_kable_extra(escape = FALSE, addtl_fmt = TRUE)}
are utilized, the following formatting occurs.
\itemize{
\item Markdown bold, italic, and underline syntax in the headers,
spanning headers, caption, and footnote will be converted to escaped LaTeX code
\item Special characters in the table body, headers, spanning headers, caption,
and footnote will be escaped with \code{.escape_latex()} or \code{.escape_latex2()}
\item The \code{"\\n"} symbol will be recognized as a line break in the table
headers, spanning headers, caption, and the table body
\item The \code{"\\n"} symbol is removed from the footnotes
}

To suppress \emph{these} additional formats, set \code{as_kable_extra(addtl_fmt = FALSE)}

Additional styling is available with
\code{kableExtra::kable_styling()} as shown in Example 2, which implements row
striping and repeated column headers in the presence of page breaks.
}

\section{HTML}{


This section discusses options intended for use with \code{output: html_document} in yaml of \code{.Rmd}.

When the default values of \code{as_kable_extra(escape = FALSE, addtl_fmt = TRUE)}
are utilized, the following formatting occurs.
\itemize{
\item The default markdown syntax in the headers and spanning headers is removed
\item Special characters in the table body, headers, spanning headers, caption,
and footnote will be escaped with \code{.escape_html()}
\item The \code{"\\n"} symbol is removed from the footnotes
}

To suppress the additional formatting, set \code{as_kable_extra(addtl_fmt = FALSE)}
}

\section{Example Output}{

\if{html}{Example 1 (PDF)}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/ddsjoberg/gtsummary/main/man-images/as_kable_extra_ex1_pdf.png" alt="image of rendered example table" style="width:45\%;">
}}

\if{html}{Example 2 (PDF)}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/ddsjoberg/gtsummary/main/man-images/as_kable_extra_ex2_pdf.png" alt="image of rendered example table" style="width:65\%;">
}}
}

\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true") && broom.helpers::.assert_package("kableExtra", pkg_search = "gtsummary", boolean = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# basic gtsummary tbl to build upon
as_kable_extra_base <-
  trial \%>\%
  select(trt, age, stage) \%>\%
  tbl_summary(by = trt) \%>\%
  bold_labels()

# Example 1 (PDF via LaTeX) ---------------------
# add linebreak in table header with '\n'
as_kable_extra_ex1_pdf <-
  as_kable_extra_base \%>\%
  modify_header(all_stat_cols() ~ "**{level}**\n*N = {n}*") \%>\%
  as_kable_extra()

# Example 2 (PDF via LaTeX) ---------------------
# additional styling in `knitr::kable()` and with
#   call to `kableExtra::kable_styling()`
as_kable_extra_ex2_pdf <-
  as_kable_extra_base \%>\%
  as_kable_extra(
    booktabs = TRUE,
    longtable = TRUE,
    linesep = ""
  ) \%>\%
  kableExtra::kable_styling(
    position = "left",
    latex_options = c("striped", "repeat_header"),
    stripe_color = "gray!15"
  )
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other gtsummary output types: 
\code{\link{as_flex_table}()},
\code{\link{as_gt}()},
\code{\link{as_hux_table}()},
\code{\link{as_kable}()},
\code{\link{as_tibble.gtsummary}()}
}
\author{
Daniel D. Sjoberg
}
\concept{gtsummary output types}
