% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inline_text.tbl_cross.R
\name{inline_text.tbl_cross}
\alias{inline_text.tbl_cross}
\title{Report statistics from cross table inline}
\usage{
\method{inline_text}{tbl_cross}(
  x,
  col_level,
  row_level = NULL,
  pvalue_fun = label_style_pvalue(prepend_p = TRUE),
  ...
)
}
\arguments{
\item{x}{(\code{tbl_cross})\cr
A \code{tbl_cross} object}

\item{col_level}{(\code{string})\cr
Level of the column variable to display.
Can also specify "\code{p.value}" for the p-value and "\code{stat_0}" for Total column.}

\item{row_level}{(\code{string})\cr
Level of the row variable to display.}

\item{pvalue_fun}{(\code{function})\cr
Function to round and format p-values. Default is \code{label_style_pvalue()}.
The function must have a numeric vector input, and return a string that is
the rounded/formatted p-value (e.g. \code{pvalue_fun = label_style_pvalue(digits = 2)}).}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A string reporting results from a gtsummary table
}
\description{
\lifecycle{maturing}
Extracts and returns statistics from a \code{tbl_cross} object for
inline reporting in an R markdown document. Detailed examples in the
\href{https://www.danieldsjoberg.com/gtsummary/articles/inline_text.html}{inline_text vignette}
}
\examples{
tbl_cross <-
  tbl_cross(trial, row = trt, col = response) \%>\%
  add_p()

inline_text(tbl_cross, row_level = "Drug A", col_level = "1")
inline_text(tbl_cross, row_level = "Total", col_level = "1")
inline_text(tbl_cross, col_level = "p.value")
}
