% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inline_text.tbl_survfit.R
\name{inline_text.tbl_survfit}
\alias{inline_text.tbl_survfit}
\title{Report statistics from survfit tables inline}
\usage{
\method{inline_text}{tbl_survfit}(
  x,
  variable = NULL,
  level = NULL,
  pattern = NULL,
  time = NULL,
  prob = NULL,
  column = NULL,
  estimate_fun = x$inputs$estimate_fun,
  pvalue_fun = label_style_pvalue(prepend_p = TRUE),
  ...
)
}
\arguments{
\item{x}{(\code{tbl_survfit})\cr
Object created from  \code{\link[=tbl_survfit]{tbl_survfit()}}}

\item{variable}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variable name of statistic to present.}

\item{level}{(\code{string})\cr
Level of the variable to display for categorical variables.
Can also specify the 'Unknown' row.  Default is \code{NULL}}

\item{pattern}{(\code{string})\cr
String indicating the statistics to return.}

\item{time, prob}{(\code{numeric} scalar)\cr
time or probability for which to return result}

\item{column}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column to print from \code{x$table_body}.
Columns may be selected with \code{time} or \code{prob} arguments as well.}

\item{estimate_fun}{(\code{function})\cr
Function to round and format estimate and confidence limits.
Default is the same function used in \code{tbl_survfit()}}

\item{pvalue_fun}{(\code{function})\cr
Function to round and format p-values. Default is \code{label_style_pvalue()}.
The function must have a numeric vector input, and return a string that is
the rounded/formatted p-value (e.g. \code{pvalue_fun = label_style_pvalue(digits = 2)}).}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A string reporting results from a gtsummary table
}
\description{
\lifecycle{maturing}\cr
Extracts and returns statistics from a \code{tbl_survfit} object for
inline reporting in an R markdown document. Detailed examples in the
\href{https://www.danieldsjoberg.com/gtsummary/articles/inline_text.html}{inline_text vignette}
}
\examples{
\dontshow{if (gtsummary:::is_pkg_installed("survival", reference_pkg = "gtsummary")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(survival)

# fit survfit
fit1 <- survfit(Surv(ttdeath, death) ~ trt, trial)
fit2 <- survfit(Surv(ttdeath, death) ~ 1, trial)

# sumarize survfit objects
tbl1 <-
  tbl_survfit(
    fit1,
    times = c(12, 24),
    label = ~"Treatment",
    label_header = "**{time} Month**"
  ) \%>\%
  add_p()

tbl2 <-
  tbl_survfit(
    fit2,
    probs = 0.5,
    label_header = "**Median Survival**"
  )

# report results inline
inline_text(tbl1, time = 24, level = "Drug B")
inline_text(tbl1, time = 24, level = "Drug B",
            pattern = "{estimate} [95\% CI {conf.low}, {conf.high}]")
inline_text(tbl1, column = p.value)
inline_text(tbl2, prob = 0.5)
\dontshow{\}) # examplesIf}
}
\author{
Daniel D. Sjoberg
}
