% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_variants.R
\name{exists_variant}
\alias{exists_variant}
\title{Check if a variant exists in the Catalog.}
\usage{
exists_variant(variant_id = NULL, verbose = FALSE, page_size = 20L)
}
\arguments{
\item{variant_id}{A character vector of GWAS Catalog variant identifiers.}

\item{verbose}{Whether the function should be
verbose about the different queries or not.}

\item{page_size}{An integer scalar indicating the
\href{https://www.ebi.ac.uk/gwas/rest/docs/api#_paging_resources}{page}
value to be used in the JSON requests, can be between \code{1} and
\code{1000}.}
}
\value{
A named logical vector, \code{TRUE} indicates that the variant does
  exist in the Catalog, \code{FALSE} otherwise. \code{NA} codes other types
  of errors. The names of the vector are the variant identifiers passed as
  \code{variant_id}.
}
\description{
This function attempts to get a variant by its variant identifier and checks
the response code. If the response code is 200 then the response has been
successful, meaning that the variant does exist in the GWAS Catalog. If the
response is 404 then the variant is not found in the Catalog database. Other
errors are mapped to NA.
}
\examples{
exists_variant('rs12345')

exists_variant('rs11235813')

}
