% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.gwer.R
\name{summary.gwer}
\alias{summary.gwer}
\alias{summary.gwer.print}
\title{Summarizing Geographically Weighted Elliptical Regression Model Fits.}
\usage{
\method{summary}{gwer}(object, ...)
}
\arguments{
\item{object}{an object with the result of the fitted geographically weighted elliptical regression model.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
returns an object of class \dQuote{summary.gwer}, a list with follow components: 
\item{coefficients}{the matrix of summarizing coefficients, standard errors and significance values for parameters hypothesis test.}
\item{dispersion}{either the supplied argument or the estimated dispersion with standard error.}
\item{residuals}{the residuals from \code{object}.}
\item{family}{family from \code{object}.}
\item{results}{a list of results values for fitted geographically weighted elliptical model.}  
\item{spdisp}{a logical value indicating whether the dispersion varies geographically from \code{object}.}
\item{df}{degrees of fredom from \code{object}.}
\item{terms}{the \code{terms} object used.}
\item{inter}{number of iterations of optimization process.}
\item{nas}{a logical vector indicating if there is \code{na} in estimation of coefficients.}
\item{type}{a character string indicating the type of residuals was obtained from \code{object}}
\item{hatmatrix}{a logical value indicating if hatmatrix was obtained from \code{object}}
\item{call}{the matched call from \code{object}.}
\item{scale}{values of the \code{4d_g} for the specified distribution from \code{object}.}
\item{scaledispersion}{values of the \code{4f_g} for the specified distribution from \code{object}.}
\item{scalevariance}{values of the scale variance for the specified distribution from \code{object}.}
}
\description{
This function produce result summary of the result of the fitted geographically weighted elliptical regression model.
}
\examples{
data(columbus, package="spData")
fit.lm <- lm(CRIME ~ INC, data=columbus)
summary(fit.lm)
gwer.bw <- gwer.sel(CRIME ~ INC, data=columbus, family = Normal(),
                 coords=cbind(columbus$X, columbus$Y))
fit.gwer <- gwer(CRIME ~ INC, family = Normal(), bandwidth = gwer.bw, hatmatrix = TRUE,
                 spdisp = TRUE, parplot = TRUE, data=columbus, method = "gwer.fit",
                 coords=cbind(columbus$X, columbus$Y))
summary(fit.gwer)  
\donttest{
data(columbus, package="spData")
fit.elliptical <- elliptical(CRIME ~ INC, family = Student(df=4), data=columbus)
summary(fit.elliptical)
gwer.bw <- gwer.sel(CRIME ~ INC, data=columbus, family = Student(df=4),
                 coords=cbind(columbus$X, columbus$Y), method = 'aic')
gwer.fitt <- gwer(CRIME ~ INC, family = Student(df=4), bandwidth = gwer.bw, hatmatrix = TRUE,
                 spdisp = TRUE, parplot = TRUE, data=columbus, method = "gwer.fit",
                 coords=cbind(columbus$X, columbus$Y))
summary(gwer.fitt)  
}
}
\references{
Brunsdon, C., Fotheringham, A. S. and Charlton, M. E. (1996). 
Geographically weighted regression: a method for exploring spatial nonstationarity.
Geographical analysis, 28(4), 281-298. \url{https://doi.org/10.1111/j.1538-4632.1996.tb00936.x}

Cysneiros, F. J. A., Paula, G. A., and Galea, M. (2007). Heteroscedastic 
symmetrical linear models. Statistics & probability letters, 77(11), 1084-1090. 
\url{https://doi.org/10.1016/j.spl.2007.01.012}
}
\seealso{
\code{\link{gwer}}, \code{\link{gwer.sel}}, \code{\link{family.elliptical}}
}
\keyword{Elliptical}
\keyword{Geographically}
\keyword{model}
\keyword{regression}
\keyword{weighted}
