% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.elliptical.R
\name{residuals.elliptical}
\alias{residuals.elliptical}
\title{Extract Residuals for Elliptical Model Fits}
\usage{
\method{residuals}{elliptical}(
  object,
  type = c("stand", "ordinal", "response", "pearson", "desvio"),
  ...
)
}
\arguments{
\item{object}{an object with the result of the fitted elliptical regression model.}

\item{type}{a character string that indicates the type of residuals. If is \code{stand} will be computed the standar residuals. 
If is \code{ordinal} will be computed the ordinal residuals. If is \code{response} will be computed the response residuals. 
If is \code{pearson} will be computed the pearson residuals. If is \code{desvio} will be computed the desviance residuals.
By default is \code{stand}.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
Residuals of the specific \code{type} extracted from the \code{object}.
}
\description{
This function compute differents type of residuals to the fitted elliptical regression model.
}
\examples{
data(luzdat)
y <- luzdat$y
x1 <- luzdat$x1 ; x1 <- factor(x1) ; x1 <- C(x1,treatment)
x2 <- luzdat$x2
x3 <- (luzdat$x2)^2
luz <- data.frame(y,x1,x2,x3)
elliptical.fitt <- elliptical(y ~ x1+x2+x3, family = Student(df=5)
,data=luz)
residuals(elliptical.fitt, type = "stand")
}
\references{
Galea, M., Paula, G. A., and Cysneiros, F. J. A. (2005). On diagnostics in 
symmetrical nonlinear models. Statistics & Probability Letters, 73(4), 459-467.
\url{https://doi.org/10.1016/j.spl.2005.04.033}
}
\seealso{
\code{\link{elliptical}}
}
\keyword{Elliptical}
\keyword{Linear}
\keyword{Residuals}
\keyword{models}
\keyword{regression}
