% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw.gwer.R
\name{bw.gwer}
\alias{bw.gwer}
\title{Optimization of Bandwidth for Geographically Weighted Elliptical Regression Model}
\usage{
bw.gwer(
  formula,
  family = Normal(),
  data,
  approach = "CV",
  kernel = "bisquare",
  adaptive = F,
  spdisp = "local",
  dispersion,
  p = 2,
  theta = 0,
  longlat = F,
  dMat
)
}
\arguments{
\item{formula}{regression model formula of a formula \code{object}.}

\item{family}{a description of the error distribution to be used in the model (see \code{family.elliptical} for more details of family functions).}

\item{data}{a SpatialPointsDataFrame or SpatialPolygonsDataFrame as defined in package \pkg{sp}.}

\item{approach}{specified by CV for cross-validation approach, by AIC for corrected Akaike information criterion approach or by MI for spatial-validation approach.}

\item{kernel}{function chosen as follows:
gaussian: wgt = exp(-.5*(vdist/bw)^2);
exponential: wgt = exp(-vdist/bw);
bisquare: wgt = (1-(vdist/bw)^2)^2 if vdist < bw, wgt=0 otherwise;
tricube: wgt = (1-(vdist/bw)^3)^3 if vdist < bw, wgt=0 otherwise;
boxcar: wgt=1 if dist < bw, wgt=0 otherwise.}

\item{adaptive}{if TRUE calculate an adaptive kernel where the bandwidth (bw) corresponds to the number of nearest neighbours (i.e. adaptive distance); default is FALSE, where a fixed kernel is found (bandwidth is a fixed distance).}

\item{spdisp}{if TRUE, by default, the dispersion parameter vary geographically in estimation process.}

\item{dispersion}{an optional fixed value for dispersion parameter.}

\item{p}{the power of the Minkowski distance, default is 2 (Euclidean distance).}

\item{theta}{an angle in radians to rotate the coordinate system, default is 0}

\item{longlat}{if TRUE, great circle distances will be calculated.}

\item{dMat}{a pre-specified distance matrix, it can be calculated by the function \code{\link{gw.dist}}.}
}
\value{
returns the bandwidth optimization value.
}
\description{
The function compute the optimal bandwidth for a given geographically weighted elliptical regression using three differents methods: cross-validation, AIC and spatial validation. This optimal bandwidth optimzing the selected function.
}
\examples{
\donttest{
data(georgia, package="spgwr")
fit.formula <- PctBach ~ TotPop90 + PctRural + PctFB + PctPov
gwer.bw.n <- bw.gwer(fit.formula, data = gSRDF, family = Student(3), 
                    longlat = TRUE, adapt = TRUE)
}
}
\references{
Brunsdon, C., Fotheringham, A. S. and Charlton, M. E. (1996). 
Geographically weighted regression: a method for exploring spatial nonstationarity.
Geographical analysis, 28(4), 281-298. \doi{10.1111/j.1538-4632.1996.tb00936.x}

Cysneiros, F. J. A., Paula, G. A., and Galea, M. (2007). Heteroscedastic 
symmetrical linear models. Statistics & probability letters, 77(11), 1084-1090. 
\doi{10.1016/j.spl.2007.01.012}

Fang, K. T., Kotz, S. and NG, K. W. (1990, ISBN:9781315897943).
Symmetric Multivariate and Related Distributions. London: Chapman and Hall.
}
\seealso{
\code{\link{gwer}}, \code{\link{elliptical}}, \code{\link{family.elliptical}}
}
\keyword{Bandwidth}
\keyword{Elliptical}
\keyword{Geographically}
\keyword{models}
\keyword{optimization}
\keyword{regression}
\keyword{weighted}
