% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elliptical.R
\name{elliptical}
\alias{elliptical}
\alias{print.elliptical}
\title{Fitting Elliptical Regression Models}
\usage{
elliptical(
  formula = formula(data),
  family = Normal,
  data,
  dispersion = NULL,
  weights,
  subset,
  na.action = "na.fail",
  method = "elliptical.fit",
  control = glm.control(epsilon = 1e-04, maxit = 100, trace = F),
  model = F,
  x = F,
  y = T,
  contrasts = NULL,
  offset,
  ...
)
}
\arguments{
\item{formula}{regression model formula of a formula \code{object}.}

\item{family}{a description of the error distribution to be used in the model (see \code{\link{family.elliptical}} for details of elliptical distribution).}

\item{data}{an optional data frame, list or environment containing the variables in the model.}

\item{dispersion}{an optional fixed value for dispersion parameter.}

\item{weights}{an optional numeric vector of \dQuote{prior weights} to be used in the fitting process.}

\item{subset}{an optional numeric vector specifying a subset of observations to be used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the data contain NAs (see \code{\link{glm}}).}

\item{method}{optimization method used to estimate the model parameters. The default method "elliptical.fit" uses Fisher's scoring method. The alternative "model.frame" returns the model frame and does no fitting.}

\item{control}{a list of parameters for controlling the fitting process. This is passed by \code{\link{glm.control}}.}

\item{model}{a logical value indicating whether model frame should be included as a component of the return.}

\item{x}{a logical value indicating whether the response vector used in the fitting process should be returned as components of the return.}

\item{y}{a logical value indicating whether model matrix used in the fitting process should be returned as components of the return.}

\item{contrasts}{an optional list. See the \code{contrasts.arg} of \code{model.matrix.default}.}

\item{offset}{this can be used to specify a \dQuote{prior known component} to be included in the linear predictor during fitting (as in \code{\link{glm}}).}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}
}
\value{
returns an object of class \dQuote{elliptical}, a list with follow components: 
\item{coefficients}{coefficients of location parameters.}
\item{dispersion}{coefficient of dispersion parameter.}
\item{residuals}{standardized residuals.}
\item{fitted.values}{the fitted mean values.}
\item{loglik}{the likelihood logarithm value for the fitted model.}  
\item{Wg}{values of the function \code{W_g(u)}.}
\item{Wgder}{values for the function \code{W^{(1)}_g(u)}.}
\item{v}{values for the function \code{V(u)}.}
\item{rank}{the numeric rank for the fitted model.}
\item{R}{the matrix of correlation for the estimated parameters.}
\item{inter}{number of iterations of optimization process.}
\item{scale}{values of the \code{4d_g} for the specified distribution.}
\item{scaledispersion}{values of the \code{4f_g} for the specified distribution.}
\item{scalevariance}{values of the scale variance for the specified distribution.}
\item{df}{degree of freedom for t-student distribution.}
\item{s, r}{shape parameters for generalized t-student distribution.}
\item{alpha}{shape parameter for contaminated normal and generalized logistic distributions.}  
\item{mp}{shape parameter for generalized logistic distribution.}
\item{epsi,sigmap}{dispersion parameters for contaminated normal distribution.}
\item{k}{shape parameter for power exponential distribution.}
\item{Xmodel}{the model matrix.}
\item{weights}{the working weights, that is the weights in the final iteration of optimization process}
\item{df.residuals}{the residual degrees of freedom.}
\item{family}{the \code{family} object used.}
\item{formula}{the \code{formula} supplied.}
\item{terms}{the \code{terms} object used.}
\item{contrasts}{(where relevant) the contrasts used.}
\item{control}{the value of the \code{control} argument used.}
\item{call}{the matched call.}
\item{y}{the response variable used.}
}
\description{
The function \code{elliptical} is used to fit linear elliptical regression models. This models is specified giving a symbolic description of the systematic and stochastic components.
}
\examples{
data(luzdat)
y <- luzdat$y
x1 <- luzdat$x1 ; x1 <- factor(x1) ; x1 <- C(x1,treatment)
x2 <- luzdat$x2
x3 <- (luzdat$x2)^2
luz <- data.frame(y,x1,x2,x3)
elliptical.fitt <- elliptical(y ~ x1+x2+x3, family = Student(df=5)
,data=luz)
elliptical.fitLII <- elliptical(y ~ x1+x2+x3, family = LogisII()
,data=luz)
}
\references{
Cysneiros, F. J. A., Paula, G. A., and Galea, M. (2007). Heteroscedastic 
symmetrical linear models. Statistics & probability letters, 77(11), 1084-1090. 
\doi{10.1016/j.spl.2007.01.012}

Fang, K. T., Kotz, S. and NG, K. W. (1990, ISBN:9781315897943).
Symmetric Multivariate and Related Distributions. London: Chapman and Hall.
}
\seealso{
\code{\link{glm}}, \code{\link{family.elliptical}}, \code{\link{summary.elliptical}}
}
\keyword{Elliptical}
\keyword{models}
\keyword{regression}
