% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{as.factor,H2OFrame-method}
\alias{as.factor,H2OFrame-method}
\title{Convert H2O Data to Factors}
\usage{
\S4method{as.factor}{H2OFrame}(x)
}
\arguments{
\item{x}{a column from an \linkS4class{H2OFrame} data set.}
}
\description{
Convert a column into a factor column.
}
\examples{
localH2O <- h2o.init()
prosPath <- system.file("extdata", "prostate.csv", package="h2o")
prostate.hex <- h2o.uploadFile(localH2O, path = prosPath)
prostate.hex[,2] <- as.factor(prostate.hex[,2])
summary(prostate.hex)
}
\seealso{
\code{\link{is.factor}}.
}

