% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.download_pojo}
\alias{h2o.download_pojo}
\title{Download the Scoring POJO of An H2O Model}
\usage{
h2o.download_pojo(model, path = "", conn = h2o.getConnection())
}
\arguments{
\item{model}{An H2OModel}

\item{path}{The path to the directory to store the POJO (no trailing slash). If "", then print to console.
The file name will be a compilable java file name.}

\item{conn}{An H2OClient object.}
}
\value{
If path is "", then pretty print the POJO to the console.
        Otherwise save it to the specified directory.
}
\description{
Download the Scoring POJO of An H2O Model
}
\examples{
library(h2o)
h <- h2o.init(nthreads=-1)
fr <- as.h2o(iris)
my_model <- h2o.gbm(x=1:4, y=5, training_frame=fr)

h2o.download_pojo(my_model)  # print the model to screen
# h2o.download_pojo(my_model, getwd())  # save to the current working directory, NOT RUN
}

