% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.scale}
\alias{h2o.scale}
\alias{scale.H2OFrame}
\title{Scaling and Centering of an H2O Frame}
\usage{
\method{scale}{H2OFrame}(x, center = TRUE, scale = TRUE)
}
\arguments{
\item{x}{An \linkS4class{H2OFrame} object.}

\item{center}{either a \code{logical} value or numeric vector of length equal to the number of columns of x.}

\item{scale}{either a \code{logical} value or numeric vector of length equal to the number of columns of x.}
}
\description{
Centers and/or scales the columns of an H2O dataset.
}
\examples{
library(h2o)
localH2O <- h2o.init()
irisPath <- system.file("extdata", "iris_wheader.csv", package="h2o")
iris.hex <- h2o.uploadFile(localH2O, path = irisPath, destination_frame = "iris.hex")
summary(iris.hex)

# Scale and center all the numeric columns in iris data set
scale(iris.hex[, 1:4])
}

