% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.giniCoef}
\alias{h2o.giniCoef}
\title{Retrieve the GINI Coefficcient}
\usage{
h2o.giniCoef(object, valid = FALSE, ...)
}
\arguments{
\item{object}{an \linkS4class{H2OBinomialMetrics} object.}

\item{valid}{TRUE to extract the metric from validation set metrics; otherwise, training is assumed}

\item{\dots}{extra arguments to be passed if `object` is of type
\linkS4class{H2OModel} (e.g. train=TRUE)}
}
\description{
Retrieves the GINI coefficient from an \linkS4class{H2OBinomialMetrics}.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

prosPath <- system.file("extdata", "prostate.csv", package="h2o")
hex <- h2o.uploadFile(prosPath)

hex[,2] <- as.factor(hex[,2])
model <- h2o.gbm(x = 3:9, y = 2, training_frame = hex, distribution = "bernoulli")
perf <- h2o.performance(model, hex)
h2o.giniCoef(perf)
}
}
\seealso{
\code{\link{h2o.auc}} for AUC,  \code{\link{h2o.giniCoef}} for the
         GINI coefficient, and \code{\link{h2o.metric}} for the various. See
         \code{\link{h2o.performance}} for creating H2OModelMetrics objects.
         threshold metrics.
}

