% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.cbind}
\alias{h2o.cbind}
\title{Combine H2O Datasets by Columns}
\usage{
h2o.cbind(...)
}
\arguments{
\item{\dots}{A sequence of H2OFrame arguments. All datasets must exist on the same H2O instance
(IP and port) and contain the same number of rows.}
}
\value{
An H2OFrame object containing the combined \dots arguments column-wise.
}
\description{
Takes a sequence of H2O data sets and combines them by column
}
\examples{
\donttest{
library(h2o)
h2o.init()
prosPath <- system.file("extdata", "prostate.csv", package="h2o")
prostate.hex <- h2o.uploadFile(path = prosPath)
prostate.cbind <- h2o.cbind(prostate.hex, prostate.hex)
head(prostate.cbind)
}
}
\seealso{
\code{\link[base]{cbind}} for the base \code{R} method.
}
