% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.varimp_plot}
\alias{h2o.varimp_plot}
\title{Plot Variable Importances}
\usage{
h2o.varimp_plot(model, num_of_features = NULL)
}
\arguments{
\item{model}{A trained model (accepts a trained random forest, GBM,
or deep learning model, will use \code{\link{h2o.std_coef_plot}}
for a trained GLM}

\item{num_of_features}{The number of features shown in the plot (default is 10 or all if less than 10).}
}
\description{
Plot Variable Importances
}
\examples{
\donttest{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.importFile(prostate_path)
prostate[,2] <- as.factor(prostate[,2])
model <- h2o.gbm(x = 3:9, y = 2, training_frame = prostate, distribution = "bernoulli")
h2o.varimp_plot(model)

# for deep learning set the variable_importance parameter to TRUE
iris_hf <- as.h2o(iris)
iris_dl <- h2o.deeplearning(x = 1:4, y = 5, training_frame = iris_hf,
variable_importances = TRUE)
h2o.varimp_plot(iris_dl)
}
}
\seealso{
\code{\link{h2o.std_coef_plot}} for GLM.
}
