% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{h2o.mojo_predict_df}
\alias{h2o.mojo_predict_df}
\title{H2O Prediction from R without having H2O running}
\usage{
h2o.mojo_predict_df(frame, mojo_zip_path, genmodel_jar_path = NULL,
  classpath = NULL, java_options = NULL, verbose = F,
  setInvNumNA = F)
}
\arguments{
\item{frame}{data.frame to score.}

\item{mojo_zip_path}{Path to MOJO zip downloaded from H2O.}

\item{genmodel_jar_path}{Optional, path to genmodel jar file. If NULL (default) then the h2o-genmodel.jar in the same folder as the MOJO zip will be used.}

\item{classpath}{Optional, specifies custom user defined classpath which will be used when scoring. If NULL (default) then the default classpath for this MOJO model will be used.}

\item{java_options}{Optional, custom user defined options for Java. By default '-Xmx4g -XX:ReservedCodeCacheSize=256m' is used.}

\item{verbose}{Optional, if TRUE, then additional debug information will be printed. FALSE by default.}

\item{setInvNumNA}{Optional, if TRUE, then then for an string that cannot be parsed into a number an N/A value will be produced, if false the command will fail. FALSE by default.}
}
\value{
Returns a data.frame containing computed predictions
}
\description{
Provides the method h2o.mojo_predict_df with which you can predict a MOJO model from R.
}
