% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/automl.R
\name{h2o.get_leaderboard}
\alias{h2o.get_leaderboard}
\title{Retrieve the leaderboard from the AutoML instance.}
\usage{
h2o.get_leaderboard(object, extra_columns = NULL)
}
\arguments{
\item{object}{The object for which to return the leaderboard. Currently, only H2OAutoML instances are supported.}

\item{extra_columns}{A string or a list of string specifying which optional columns should be added to the leaderboard. Defaults to None.
Currently supported extensions are:
\itemize{
\item{'ALL': adds all columns below.}
\item{'training_time_ms': column providing the training time of each model in milliseconds (doesn't include the training of cross validation models).}
\item{'predict_time_per_row_ms': column providing the average prediction time by the model for a single row.}
}}
}
\value{
An H2OFrame representing the leaderboard.
}
\description{
Contrary to the default leaderboard attached to the automl instance, this one can return columns other than the metrics.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
votes_path <- system.file("extdata", "housevotes.csv", package = "h2o")
votes_hf <- h2o.uploadFile(path = votes_path, header = TRUE)
aml <- h2o.automl(y = "Class", project_name="aml_housevotes",
                  training_frame = votes_hf, max_runtime_secs = 30)
lb_all <- h2o.get_leaderboard(aml, 'ALL')
lb_custom <- h2o.get_leaderboard(aml, c('predict_time_per_row_ms', 'training_time_ms'))
}
}
