% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.drop_duplicates}
\alias{h2o.drop_duplicates}
\title{Drops duplicated rows.}
\usage{
h2o.drop_duplicates(frame, columns, keep = "first")
}
\arguments{
\item{frame}{An H2OFrame object to drop duplicates on.}

\item{columns}{Columns to compare during the duplicate detection process.}

\item{keep}{Which rows to keep. The "first" value (default) keeps the first row and delets the rest. 
The "last" keeps the last row.}
}
\description{
Drops duplicated rows across specified columns.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

data <- as.h2o(iris)
deduplicated_data <- h2o.drop_duplicates(data, c("Species", "Sepal.Length"), keep = "first")
}
}
