% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.reset_threshold}
\alias{h2o.reset_threshold}
\title{Reset model threshold and return old threshold value.}
\usage{
h2o.reset_threshold(object, threshold)
}
\arguments{
\item{object}{An \linkS4class{H2OModel} object.}

\item{threshold}{A threshold value from 0 to 1 included.}
}
\value{
Returns the previous threshold used in the model.
}
\description{
Reset model threshold and return old threshold value.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.importFile(prostate_path)
prostate[, 2] <- as.factor(prostate[, 2])
prostate_glm <- h2o.glm(y = "CAPSULE", x = c("AGE", "RACE", "PSA", "DCAPS"), 
                        training_frame = prostate, family = "binomial", 
                        nfolds = 0, alpha = 0.5, lambda_search = FALSE)
old_threshold <- h2o.reset_threshold(prostate_glm, 0.9)
}
}
