% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.topN}
\alias{h2o.topN}
\title{H2O topN}
\usage{
h2o.topN(x, column, nPercent)
}
\arguments{
\item{x}{an H2OFrame}

\item{column}{is a column name or column index to grab the top N percent value from}

\item{nPercent}{is a top percentage value to grab}
}
\value{
An H2OFrame with 2 columns.  The first column is the original row indices, second column contains the topN values
}
\description{
Extract the top N percent  of values of a column and return it in a H2OFrame.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://s3.amazonaws.com/h2o-public-test-data/bigdata/laptop/jira/TopBottomNRep4.csv.zip"
dataset <- h2o.importFile(f)
frameNames <- names(dataset)
nPercent <- c(1, 2, 3, 4)
nP <- nPercent[sample(1:length(nPercent), 1, replace = FALSE)]
colIndex <- sample(1:length(frameNames), 1, replace = FALSE)
h2o.topN(dataset, frameNames[colIndex], nP)
}
}
