% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gam.R
\name{h2o.gam}
\alias{h2o.gam}
\title{Fit a General Additive Model}
\usage{
h2o.gam(
  x,
  y,
  training_frame,
  gam_columns,
  model_id = NULL,
  validation_frame = NULL,
  nfolds = 0,
  seed = -1,
  keep_cross_validation_models = TRUE,
  keep_cross_validation_predictions = FALSE,
  keep_cross_validation_fold_assignment = FALSE,
  fold_assignment = c("AUTO", "Random", "Modulo", "Stratified"),
  fold_column = NULL,
  ignore_const_cols = TRUE,
  score_each_iteration = FALSE,
  offset_column = NULL,
  weights_column = NULL,
  family = c("AUTO", "gaussian", "binomial", "quasibinomial", "ordinal", "multinomial",
    "poisson", "gamma", "tweedie", "negativebinomial", "fractionalbinomial"),
  tweedie_variance_power = 0,
  tweedie_link_power = 0,
  theta = 0,
  solver = c("AUTO", "IRLSM", "L_BFGS", "COORDINATE_DESCENT_NAIVE",
    "COORDINATE_DESCENT", "GRADIENT_DESCENT_LH", "GRADIENT_DESCENT_SQERR"),
  alpha = NULL,
  lambda = NULL,
  lambda_search = FALSE,
  early_stopping = TRUE,
  nlambdas = -1,
  standardize = FALSE,
  missing_values_handling = c("MeanImputation", "Skip", "PlugValues"),
  plug_values = NULL,
  compute_p_values = FALSE,
  remove_collinear_columns = FALSE,
  intercept = TRUE,
  non_negative = FALSE,
  max_iterations = -1,
  objective_epsilon = -1,
  beta_epsilon = 1e-04,
  gradient_epsilon = -1,
  link = c("family_default", "identity", "logit", "log", "inverse", "tweedie",
    "ologit"),
  startval = NULL,
  prior = -1,
  cold_start = FALSE,
  lambda_min_ratio = -1,
  beta_constraints = NULL,
  max_active_predictors = -1,
  interactions = NULL,
  interaction_pairs = NULL,
  obj_reg = -1,
  export_checkpoints_dir = NULL,
  stopping_rounds = 0,
  stopping_metric = c("AUTO", "deviance", "logloss", "MSE", "RMSE", "MAE", "RMSLE",
    "AUC", "AUCPR", "lift_top_group", "misclassification", "mean_per_class_error",
    "custom", "custom_increasing"),
  stopping_tolerance = 0.001,
  balance_classes = FALSE,
  class_sampling_factors = NULL,
  max_after_balance_size = 5,
  max_runtime_secs = 0,
  custom_metric_func = NULL,
  num_knots = NULL,
  knot_ids = NULL,
  standardize_tp_gam_cols = FALSE,
  scale_tp_penalty_mat = FALSE,
  bs = NULL,
  scale = NULL,
  keep_gam_cols = FALSE,
  auc_type = c("AUTO", "NONE", "MACRO_OVR", "WEIGHTED_OVR", "MACRO_OVO",
    "WEIGHTED_OVO")
)
}
\arguments{
\item{x}{(Optional) A vector containing the names or indices of the predictor variables to use in building the model.
If x is missing, then all columns except y are used.}

\item{y}{The name or column index of the response variable in the data. 
The response must be either a numeric or a categorical/factor variable. 
If the response is numeric, then a regression model will be trained, otherwise it will train a classification model.}

\item{training_frame}{Id of the training data frame.}

\item{gam_columns}{Arrays of predictor column names for gam for smoothers using single or multiple predictors like
{{'c1'},{'c2','c3'},{'c4'},...}}

\item{model_id}{Destination id for this model; auto-generated if not specified.}

\item{validation_frame}{Id of the validation data frame.}

\item{nfolds}{Number of folds for K-fold cross-validation (0 to disable or >= 2). Defaults to 0.}

\item{seed}{Seed for random numbers (affects certain parts of the algo that are stochastic and those might or might not be enabled by default).
Defaults to -1 (time-based random number).}

\item{keep_cross_validation_models}{\code{Logical}. Whether to keep the cross-validation models. Defaults to TRUE.}

\item{keep_cross_validation_predictions}{\code{Logical}. Whether to keep the predictions of the cross-validation models. Defaults to FALSE.}

\item{keep_cross_validation_fold_assignment}{\code{Logical}. Whether to keep the cross-validation fold assignment. Defaults to FALSE.}

\item{fold_assignment}{Cross-validation fold assignment scheme, if fold_column is not specified. The 'Stratified' option will
stratify the folds based on the response variable, for classification problems. Must be one of: "AUTO",
"Random", "Modulo", "Stratified". Defaults to AUTO.}

\item{fold_column}{Column with cross-validation fold index assignment per observation.}

\item{ignore_const_cols}{\code{Logical}. Ignore constant columns. Defaults to TRUE.}

\item{score_each_iteration}{\code{Logical}. Whether to score during each iteration of model training. Defaults to FALSE.}

\item{offset_column}{Offset column. This will be added to the combination of columns before applying the link function.}

\item{weights_column}{Column with observation weights. Giving some observation a weight of zero is equivalent to excluding it from
the dataset; giving an observation a relative weight of 2 is equivalent to repeating that row twice. Negative
weights are not allowed. Note: Weights are per-row observation weights and do not increase the size of the
data frame. This is typically the number of times a row is repeated, but non-integer values are supported as
well. During training, rows with higher weights matter more, due to the larger loss function pre-factor. If
you set weight = 0 for a row, the returned prediction frame at that row is zero and this is incorrect. To get
an accurate prediction, remove all rows with weight == 0.}

\item{family}{Family. Use binomial for classification with logistic regression, others are for regression problems. Must be
one of: "AUTO", "gaussian", "binomial", "quasibinomial", "ordinal", "multinomial", "poisson", "gamma",
"tweedie", "negativebinomial", "fractionalbinomial". Defaults to AUTO.}

\item{tweedie_variance_power}{Tweedie variance power Defaults to 0.}

\item{tweedie_link_power}{Tweedie link power Defaults to 0.}

\item{theta}{Theta Defaults to 0.}

\item{solver}{AUTO will set the solver based on given data and the other parameters. IRLSM is fast on on problems with small
number of predictors and for lambda-search with L1 penalty, L_BFGS scales better for datasets with many
columns. Must be one of: "AUTO", "IRLSM", "L_BFGS", "COORDINATE_DESCENT_NAIVE", "COORDINATE_DESCENT",
"GRADIENT_DESCENT_LH", "GRADIENT_DESCENT_SQERR". Defaults to AUTO.}

\item{alpha}{Distribution of regularization between the L1 (Lasso) and L2 (Ridge) penalties. A value of 1 for alpha
represents Lasso regression, a value of 0 produces Ridge regression, and anything in between specifies the
amount of mixing between the two. Default value of alpha is 0 when SOLVER = 'L-BFGS'; 0.5 otherwise.}

\item{lambda}{Regularization strength}

\item{lambda_search}{\code{Logical}. Use lambda search starting at lambda max, given lambda is then interpreted as lambda min
Defaults to FALSE.}

\item{early_stopping}{\code{Logical}. Stop early when there is no more relative improvement on train or validation (if provided)
Defaults to TRUE.}

\item{nlambdas}{Number of lambdas to be used in a search. Default indicates: If alpha is zero, with lambda search set to True,
the value of nlamdas is set to 30 (fewer lambdas are needed for ridge regression) otherwise it is set to 100.
Defaults to -1.}

\item{standardize}{\code{Logical}. Standardize numeric columns to have zero mean and unit variance Defaults to FALSE.}

\item{missing_values_handling}{Handling of missing values. Either MeanImputation, Skip or PlugValues. Must be one of: "MeanImputation",
"Skip", "PlugValues". Defaults to MeanImputation.}

\item{plug_values}{Plug Values (a single row frame containing values that will be used to impute missing values of the
training/validation frame, use with conjunction missing_values_handling = PlugValues)}

\item{compute_p_values}{\code{Logical}. Request p-values computation, p-values work only with IRLSM solver and no regularization
Defaults to FALSE.}

\item{remove_collinear_columns}{\code{Logical}. In case of linearly dependent columns, remove some of the dependent columns Defaults to FALSE.}

\item{intercept}{\code{Logical}. Include constant term in the model Defaults to TRUE.}

\item{non_negative}{\code{Logical}. Restrict coefficients (not intercept) to be non-negative Defaults to FALSE.}

\item{max_iterations}{Maximum number of iterations Defaults to -1.}

\item{objective_epsilon}{Converge if  objective value changes less than this. Default indicates: If lambda_search is set to True the
value of objective_epsilon is set to .0001. If the lambda_search is set to False and lambda is equal to zero,
the value of objective_epsilon is set to .000001, for any other value of lambda the default value of
objective_epsilon is set to .0001. Defaults to -1.}

\item{beta_epsilon}{Converge if  beta changes less (using L-infinity norm) than beta esilon, ONLY applies to IRLSM solver
Defaults to 0.0001.}

\item{gradient_epsilon}{Converge if  objective changes less (using L-infinity norm) than this, ONLY applies to L-BFGS solver. Default
indicates: If lambda_search is set to False and lambda is equal to zero, the default value of gradient_epsilon
is equal to .000001, otherwise the default value is .0001. If lambda_search is set to True, the conditional
values above are 1E-8 and 1E-6 respectively. Defaults to -1.}

\item{link}{Link function. Must be one of: "family_default", "identity", "logit", "log", "inverse", "tweedie", "ologit".
Defaults to family_default.}

\item{startval}{double array to initialize coefficients for GAM.}

\item{prior}{Prior probability for y==1. To be used only for logistic regression iff the data has been sampled and the mean
of response does not reflect reality. Defaults to -1.}

\item{cold_start}{\code{Logical}. Only applicable to multiple alpha/lambda values when calling GLM from GAM.  If false, build
the next model for next set of alpha/lambda values starting from the values provided by current model.  If
true will start GLM model from scratch. Defaults to FALSE.}

\item{lambda_min_ratio}{Minimum lambda used in lambda search, specified as a ratio of lambda_max (the smallest lambda that drives all
coefficients to zero). Default indicates: if the number of observations is greater than the number of
variables, then lambda_min_ratio is set to 0.0001; if the number of observations is less than the number of
variables, then lambda_min_ratio is set to 0.01. Defaults to -1.}

\item{beta_constraints}{Beta constraints}

\item{max_active_predictors}{Maximum number of active predictors during computation. Use as a stopping criterion to prevent expensive model
building with many predictors. Default indicates: If the IRLSM solver is used, the value of
max_active_predictors is set to 5000 otherwise it is set to 100000000. Defaults to -1.}

\item{interactions}{A list of predictor column indices to interact. All pairwise combinations will be computed for the list.}

\item{interaction_pairs}{A list of pairwise (first order) column interactions.}

\item{obj_reg}{Likelihood divider in objective value computation, default is 1/nobs Defaults to -1.}

\item{export_checkpoints_dir}{Automatically export generated models to this directory.}

\item{stopping_rounds}{Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the
stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable) Defaults to 0.}

\item{stopping_metric}{Metric to use for early stopping (AUTO: logloss for classification, deviance for regression and
anonomaly_score for Isolation Forest). Note that custom and custom_increasing can only be used in GBM and DRF
with the Python client. Must be one of: "AUTO", "deviance", "logloss", "MSE", "RMSE", "MAE", "RMSLE", "AUC",
"AUCPR", "lift_top_group", "misclassification", "mean_per_class_error", "custom", "custom_increasing".
Defaults to AUTO.}

\item{stopping_tolerance}{Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this
much) Defaults to 0.001.}

\item{balance_classes}{\code{Logical}. Balance training data class counts via over/under-sampling (for imbalanced data). Defaults to
FALSE.}

\item{class_sampling_factors}{Desired over/under-sampling ratios per class (in lexicographic order). If not specified, sampling factors will
be automatically computed to obtain class balance during training. Requires balance_classes.}

\item{max_after_balance_size}{Maximum relative size of the training data after balancing class counts (can be less than 1.0). Requires
balance_classes. Defaults to 5.0.}

\item{max_runtime_secs}{Maximum allowed runtime in seconds for model training. Use 0 to disable. Defaults to 0.}

\item{custom_metric_func}{Reference to custom evaluation function, format: `language:keyName=funcName`}

\item{num_knots}{Number of knots for gam predictors}

\item{knot_ids}{String arrays storing frame keys of knots.  One for each gam column set specified in gam_columns}

\item{standardize_tp_gam_cols}{\code{Logical}. standardize tp (thin plate) predictor columns Defaults to FALSE.}

\item{scale_tp_penalty_mat}{\code{Logical}. Scale penalty matrix for tp (thin plate) smoothers as in R Defaults to FALSE.}

\item{bs}{Basis function type for each gam predictors, 0 for cr, 1 for thin plate regression with knots, 2 for thin
plate regression with SVD.  If specified, must be the same size as gam_columns}

\item{scale}{Smoothing parameter for gam predictors.  If specified, must be of the same length as gam_columns}

\item{keep_gam_cols}{\code{Logical}. Save keys of model matrix Defaults to FALSE.}

\item{auc_type}{Set default multinomial AUC type. Must be one of: "AUTO", "NONE", "MACRO_OVR", "WEIGHTED_OVR", "MACRO_OVO",
"WEIGHTED_OVO". Defaults to AUTO.}
}
\description{
Creates a generalized additive model, specified by a response variable, a set of predictors, and a
description of the error distribution.
}
\examples{
\dontrun{
h2o.init()

# Run GAM of CAPSULE ~ AGE + RACE + PSA + DCAPS
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(path = prostate_path)
prostate$CAPSULE <- as.factor(prostate$CAPSULE)
h2o.gam(y = "CAPSULE", x = c("RACE"), gam_columns = c("PSA"),
     training_frame = prostate, family = "binomial")

}
}
