% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.describe}
\alias{h2o.describe}
\title{H2O Description of A Dataset}
\usage{
h2o.describe(frame)
}
\arguments{
\item{frame}{An H2OFrame object.}
}
\value{
A table with the Frame stats.
}
\description{
Reports the "Flow" style summary rollups on an instance of H2OFrame. Includes
information about column types, mins/maxs/missing/zero counts/stds/number of levels
}
\examples{
\dontrun{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.importFile(path = prostate_path)
h2o.describe(prostate)
}
}
