% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.loglikelihood}
\alias{h2o.loglikelihood}
\title{Retrieve the log likelihood value}
\usage{
h2o.loglikelihood(object, train = FALSE, valid = FALSE, xval = FALSE)
}
\arguments{
\item{object}{An \linkS4class{H2OModel} or \linkS4class{H2OModelMetrics}.}

\item{train}{Retrieve the training log likelihood}

\item{valid}{Retrieve the validation log likelihood}

\item{xval}{Retrieve the cross-validation log likelihood}
}
\description{
Retrieves the log likelihood value.
If "train", "valid", and "xval" parameters are FALSE (default), then the training log likelihood value is returned. If more
than one parameter is set to TRUE, then a named vector of log likelihoods is returned, where the names are "train", "valid"
or "xval".
}
\examples{
\dontrun{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(path = prostate_path)
p_sid <- h2o.runif(prostate)
prostate_train <- prostate[p_sid > .2,]
prostate_glm <- h2o.glm(x = 3:7, y = 2, training_frame = prostate_train)
ll_basic <- h2o.loglikelihood(prostate_glm)
print(ll_basic)
}
}
