% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.range}
\alias{h2o.range}
\title{Returns a vector containing the minimum and maximum of all the given arguments.}
\usage{
h2o.range(x, na.rm = FALSE, finite = FALSE)
}
\arguments{
\item{x}{An H2OFrame object.}

\item{na.rm}{\code{logical}. indicating whether missing values should be removed.}

\item{finite}{\code{logical}. indicating if all non-finite elements should be omitted.}
}
\description{
Returns a vector containing the minimum and maximum of all the given arguments.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

f <- "https://h2o-public-test-data.s3.amazonaws.com/smalldata/iris/iris_train.csv"
iris <- h2o.importFile(f)
h2o.range(iris["petal_len"], na.rm = TRUE, finite = TRUE)
}
}
\seealso{
\code{\link[base]{range}} for the base R implementation.
}
