% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHDI.R
\name{plotHDI}
\alias{plotHDI}
\title{Plots highest density interval (HDI) from (MCMC) samples and prints HDI in the R console. HDI is indicated by a red line.}
\usage{
plotHDI(sample = NULL, credMass = 0.95, Title = NULL, xLab = "Value",
  yLab = "Density", binSize = 30, ...)
}
\arguments{
\item{sample}{MCMC samples}

\item{credMass}{A scalar between 0 and 1, indicating the mass within the credible interval that is to be estimated.}

\item{Title}{Character value containing the main title for the plot}

\item{xLab}{Character value containing the x label}

\item{yLab}{Character value containing the y label}

\item{binSize}{Integer value specifyin ghow wide the bars on the histogram should be. Defaults to 30.}

\item{...}{Arguments that can be additionally supplied to geom_histogram}
}
\value{
A vector containing the limits of the HDI
}
\description{
Based on John Kruschke's codes \url{http://www.indiana.edu/~kruschke/DoingBayesianDataAnalysis/}
}

