% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latent_scores.R
\name{latent_scores}
\alias{latent_scores}
\title{Estimates of Latent Preferences/Abilities}
\usage{
latent_scores(x, digits = 3)
}
\arguments{
\item{x}{An object of class \code{hIRT}}

\item{digits}{The number of significant digits to use when printing}
}
\value{
A data frame of EAP estimates of latent preferences and their approximate standard errors.
}
\description{
EAP estimates of latent preferences for either \code{hltm} or \code{hgrm} models.
}
\examples{
y <- nes_econ2008[, -(1:3)]
x <- model.matrix( ~ party * educ, nes_econ2008)
z <- model.matrix( ~ party, nes_econ2008)
nes_m1 <- hgrm(y, x, z)
pref <- latent_scores(nes_m1)
require(ggplot2)
ggplot(data = nes_econ2008) +
geom_density(aes(x = pref$est, col = party))
}
