% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dem_split.R
\name{dem_split}
\alias{dem_split}
\title{Split DEM into smaller tiles}
\usage{
dem_split(data, size, parallel = FALSE, ncores = (parallel::detectCores() - 1))
}
\arguments{
\item{data}{Digital elevation model of class RasterLayer.}

\item{size}{Size of tiles, in the same unit as the RasterLayer.}

\item{parallel}{Logical. Use parallel processing? Note: parallel must be installed.}

\item{ncores}{Number of cores to use when parallel = TRUE.}
}
\value{
List of RasterLayers.
}
\description{
Split DEM into smaller tiles
}
\examples{
L <- habtools::extent(horseshoe) # size of horseshoe = 8m
size <- 2 # size of target tiles
(L / size)^2 # number of target tiles = 16
dem_list <- dem_split(horseshoe, 2)
length(dem_list)

}
