% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{get_item_by_id}
\alias{get_item_by_id}
\title{Get Hacker News by Id}
\usage{
get_item_by_id(id)
}
\arguments{
\item{id}{id of the item that should be retrieved}
}
\value{
item corresponding to the specified id
}
\description{
Retrieves the item
corresponding to specified id using Hacker News API
}
\details{
The API in some cases returns a null response.
When this situation occurs it is assumed that the item
does not exist and NA is returned.
}
\examples{
\donttest{
# retrieve the id of the latest Hacker News item
last_item_id <- get_max_item_id()
last_item_id

# retrieve the latest Hacker News item
last_hn_item <- get_item_by_id(last_item_id)
last_hn_item
}

}
