% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosh_nlsfit.R
\name{fit.cosh}
\alias{fit.cosh}
\title{Fits a sum of several \code{cosh}-functions}
\usage{
fit.cosh(effMass, cf, t1, t2, useCov = FALSE, m.init, par, n.cosh = 2,
  adjust.n.cosh = FALSE, every, ...)
}
\arguments{
\item{effMass}{An object of class \code{effectivemass} generated by a call
to \code{bootstrap.effectivemass}.  Either \code{effMass} or \code{cf} has
to be provided, but not both!}

\item{cf}{An object of class \code{cf_boot} generated by a call to
\code{bootstrap.cf}.  Either \code{cf} or \code{effMass} has to be provided,
but not both!}

\item{t1}{The fit range. If several correlators are fitted, this is
automatically replicated accordingly. The fit range is adjusted such that
\code{NA}s are removed from the fit. They must fulfill \eqn{t_1<t_2}{t1<t2}.
For symmetric correlators, they must both run from 0 to \code{T/2-1},
otherwise from 0 to \code{T-1}.}

\item{t2}{see t1}

\item{useCov}{Use the correlated chisquare. This works only for not too
noisy data.}

\item{m.init}{Initial guess of the effective mass, i.e. the smallest m_i.}

\item{par}{Array of length \code{2*n.cosh} with initial guesses for the
effective masses in the first \code{n.cosh} entries and initial guesses for
the amplitudes in the last \code{n.cosh} entries.}

\item{n.cosh}{Number of \code{cosh}-functions summed over.}

\item{adjust.n.cosh}{Only relevant, if \code{n.cosh=2}. If set to
\code{TRUE}, \code{n.cosh} can be adjusted to \code{n.cosh=1} automatically
in case the excited state cannot be resolved.}

\item{every}{Fit only a part of the data points. Indices that are not
multiples of \code{every} are skipped. If no value is provided, all points
are taken into account.}

\item{...}{Additional parameters passed to the fit function. But the fit
function is fixed and does not accept any arguments, so it will just crash.
Therefore, don't use this!}
}
\value{
An object with class \code{coshfit} is returned. It contains all the
data of the input object \code{effMass} or the \code{cf} object as a member.
The following member objects are added:

\code{t0}: the object returned by the \code{optim} on the original data. The
format is as in \code{par}.

\code{t}: the bootstrap values of the results.

\code{se}: errors calculated via bootstrap on the results.

\code{ii}: the index array of data used in the fit.

\code{invCovMatrix}: the inverse covariance matrix.

\code{dof}: the degrees of freedom of the fit.

\code{chisqr}: Chi squared value of the fit.

\code{Qval}: p-value of the fit.
}
\description{
Performs a correlated fit of a sum of several \code{cosh}-functions
\eqn{\sum_i a_i \cosh(m_i t)} to data generated with
\code{bootstrap.effectivemass}. Requires the same input and produces
analogous output as \link{fit.effectivemass}.  The fit itself is performed
by \link{bootstrap.nlsfit}.
}
\examples{

data(samplecf)
samplecf <- bootstrap.cf(cf=samplecf, boot.R=99, boot.l=2, seed=1442556)
effmass <- fit.cosh(bootstrap.effectivemass(cf=samplecf), t1=15, t2=23)
summary(effmass)
plot(effmass, ylim=c(0.14,0.15))
}
\seealso{
\code{\link{bootstrap.effectivemass}},
\code{\link{bootstrap.gevp}}, \code{\link{invertCovMatrix}},
\code{\link{bootstrap.nlsfit}}, \code{\link{fit.effectivemass}}
}
\author{
Johann Ostmeyer, \email{ostmeyer@hiskp.uni-bonn.de}
}
\keyword{optim}
