% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.plateau2cf.R
\name{fit.plateau2cf}
\alias{fit.plateau2cf}
\title{fits a plateau to an object of class \code{cf}}
\usage{
fit.plateau2cf(cf, t1, t2, useCov = FALSE)
}
\arguments{
\item{cf}{input object of class \code{cf}}

\item{t1}{starting t-value for the fit}

\item{t2}{final t-value for the fit.}

\item{useCov}{perform a correlated chisquare fit or not.}
}
\value{
Returns a list with elements \item{plateau}{ the fitted plateau
value } \item{dplateau}{ its error }
}
\description{
where applicable, a plateau is fitted to the averaged data in \code{cf}
using a (correlated) chisquare fit.
}
\examples{

data(correlatormatrix)
cfnew <- extractSingleCor.cf(correlatormatrix, id=1)
cfnew <- bootstrap.cf(cfnew, boot.R=99, boot.l=1)
X <- fit.plateau2cf(cfnew, t1=13, t2=20)
}
\seealso{
\code{\link{cf}}
}
\author{
Carsten Urbach \email{curbach@gmx.de}
}
\keyword{bootstrap}
\keyword{fit}
