% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_diversities.R
\name{calculate_diversities}
\alias{calculate_diversities}
\title{Calculate Diversities Indices}
\usage{
calculate_diversities(x, cutoff, control, sample, gene, perc_susc)
}
\arguments{
\item{x}{a \code{data.frame} containing the data.}

\item{cutoff}{value for percent susceptible cutoff. \code{Numeric}.}

\item{control}{value used to denote the susceptible control in the \code{gene}
column. \code{Character}.}

\item{sample}{column providing the unique identification for each sample
being tested. \code{Character}.}

\item{gene}{column providing the gene(s) being tested. \code{Character}.}

\item{perc_susc}{column providing the percent susceptible reactions.
\code{Character}.}
}
\value{
a \code{hagis.diversities} object.

A \code{hagis.diversities} object is a \code{list} containing:
\itemize{
\item Number of Samples
\item Number of Pathotypes
\item Simple Diversity Index
\item Gleason Diversity Index
\item Shannon Diversity Index
\item Simpson Diversity Index
\item Evenness Diversity Index
}
}
\description{
Calculate five pathogen diversity indices.

Diversity indices include:
\itemize{
\item Simple diversity index, which will show the proportion of unique pathotypes
to total samples. As the values gets closer to 1, there is greater
diversity in pathoypes within the population. Simple diversity is
calculated as:
\deqn{ D = \frac{Np}{Ns} }{ D = Np / Ns }
where \eqn{Np} is the number of pathotypes and \eqn{Ns} is the number of
samples.
\item Gleason diversity index, an alternate version of Simple diversity index, is
less sensitive to sample size than the Simple index.
\deqn{ D = \frac{ (Np - 1) }{ log(Ns)}}{ D = (Np -1) / log(Ns) }
Where \eqn{Np} is the number of pathotypes and \eqn{Ns} is the number of
samples.
\item Shannon diversity index is typically between 1.5 and 3.5, as richness and
evenness of the population increase, so does the Shannon index value.
\deqn{ D = -\sum_{i = 1}^{R} p_i \log p_i }{ D = -sum p_i log(p_i) } Where
\eqn{p_i} is the proportional abundance of species \eqn{i}.
\item Simpson diversity index values range from 0 to 1, 1 represents high
diversity and 0 represents no diversity. Where diversity is calculated as:
\deqn{ D = \sum_{i = 1}^{R} p_i^2 }{ D = sum p_i^2 }
\item Evenness ranges from 0 to 1, as the Evenness value approaches 1, there is a
more even distribution of each pathoype's frequency within the population.
Where Evenness is calculated as:
\deqn{ D = \frac{H'}{log(Np) }}{ D = H' / log(Np) }
where \eqn{H'} is the Shannon diversity index and \eqn{Np} is the number
of pathotypes.
}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Using the built-in data set, P_sojae_survey
data(P_sojae_survey)

P_sojae_survey

# calculate susceptibilities with a 60 \% cutoff value
diversities <- calculate_diversities(x = P_sojae_survey,
                                     cutoff = 60,
                                     control = "susceptible",
                                     sample = "Isolate",
                                     gene = "Rps",
                                     perc_susc = "perc.susc")

diversities
\dontshow{\}) # examplesIf}
}
