% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commons_divisions.R
\name{commons_divisions}
\alias{commons_divisions}
\title{commons_divisions}
\usage{
commons_divisions(comsDivType = c("all", "date", "aye", "no", "voteSummary",
  "voteFull", "session", "uinSummary", "uinFull"))
}
\arguments{
\item{comsDivType}{The type of data you want, allows the arguments 'all', 'date', 'aye', 'no', 'voteSummary', 'voteFull', 'uinSummary', 'uinFull' and 'session'. Defaults to 'all'.}

\item{all}{Returns a data frame with all available divisions.}

\item{date}{Requests a date in yyyy-mm-dd format and returns a data frame with all available divisions on that date.}

\item{aye}{Returns a data frame with all divisions where a given MP voted aye.}

\item{no}{Returns a data frame with all divisions where a given MP voted no.}

\item{voteSummary}{Requests a division ID, and returns a summary of results of that division in a data frame.}

\item{voteFull}{Requests a division ID, and returns a data frame with details on how each individual member voted.}

\item{uinSummary}{Requests a division UIN and returns a data frame with a summary of results of that division.}

\item{uinFull}{Requests a division UIN and returns a data frame with the full results of that division.}

\item{session}{Requests a session in yyyy/yy format (e.g. 2016/17) and returns a data frame with all divisions in that session.}
}
\description{
Imports data on House of Commons divisions
}
\examples{
\dontrun{
x <- commons_divisions('all')

x <- commons_divisions('date')

x <- commons_divisions('no')

x <- commons_divisions('aye')

x <- commons_divisions('voteSummary')

x <- commons_divisions('voteFull')

x <- commons_divisions('session')

x <- commons_divisions('uinSummary')

x <- commons_divisions('uinFull')
}
}
\keyword{divisions}

