% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commons_division_date.R
\name{commons_division_date}
\alias{commons_division_date}
\alias{hansard_commons_division_date}
\title{House of Commons Division Dates}
\usage{
commons_division_date(date = NULL, extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case", verbose = TRUE)

hansard_commons_division_date(date = NULL, extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case", verbose = TRUE)
}
\arguments{
\item{date}{Returns all divisions on a given date.
Defaults to \code{NULL}.}

\item{extra_args}{Additional parameters to pass to API.
Defaults to \code{NULL}.}

\item{tidy}{Logical parameter. If TRUE, fixes the variable names in the
tibble to remove special characters and superfluous text, and converts
the variable names to a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy = TRUE}. Accepts one of \code{'snake_case'}, \code{'camelCase'}
and \code{'period.case'}. Defaults to \code{'snake_case'}.}

\item{verbose}{If \code{TRUE}, returns data to console on the progress of
the API request. Defaults to \code{FALSE}.}
}
\value{
A tibble with the dates of divisions in the House of Commons.
}
\description{
Returns a tibble with the divisions (votes) in the
House of Commons on a given date.
}
\examples{
\dontrun{
# all commons divisions on 19 April 2017
x <- commons_division_date("2017-04-19")
}

}
