% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haploreg.R
\name{queryHaploreg}
\alias{queryHaploreg}
\title{This function queries HaploReg web-based tool and returns results.}
\usage{
queryHaploreg(
  query = NULL,
  file = NULL,
  study = NULL,
  ldThresh = 0.8,
  ldPop = "EUR",
  epi = "vanilla",
  cons = "siphy",
  genetypes = "gencode",
  url = Haploreg.settings[["base.url"]],
  timeout = 100,
  encoding = "UTF-8",
  querySNP = FALSE,
  fields = NULL,
  verbose = FALSE
)
}
\arguments{
\item{query}{Query (a vector of rsIDs).}

\item{file}{A text file (one refSNP ID per line).}

\item{study}{A particular study. See function \code{getHaploRegStudyList(...)}.
Default: \code{NULL}.}

\item{ldThresh}{LD threshold, r2 (select NA to only show query variants). 
Default: 0.8.}

\item{ldPop}{1000G Phase 1 population for LD calculation. 
Can be: "AFR", "AMR", "ASN". Default: "EUR".}

\item{epi}{Source for epigenomes. 
Possible values: \code{vanilla} for ChromHMM (Core 15-state model);
\code{imputed} for ChromHMM (25-state model using 12 imputed marks);
\code{methyl} for H3K4me1/H3K4me3 peaks;
\code{acetyl} for H3K27ac/H3K9ac peaks.
Default: \code{vanilla}.}

\item{cons}{Mammalian conservation algorithm. 
Possible values: \code{gerp} for GERP,
\code{siphy} for SiPhy-omega,
\code{both} for both.
Default: \code{siphy}.}

\item{genetypes}{Show position relative to.
Possible values: \code{gencode} for Gencode genes;
\code{refseq} for RefSeq genes;
\code{both} for both.
Default: \code{gencode}.}

\item{url}{HaploReg url address. 
Default: <https://pubs.broadinstitute.org/mammals/haploreg/haploreg.php>}

\item{timeout}{A \code{timeout} parameter for \code{curl}.
Default: 100}

\item{encoding}{sets the \code{encoding} for correct retrieval web-page content.
Default: \code{UTF-8}}

\item{querySNP}{A flag indicating to return query SNPs only. 
Default: \code{FALSE}}

\item{fields}{A set of fields to extract. Refer to the package vignette 
for available fields. Default: \code{All}.}

\item{verbose}{Verbosing output. Default: FALSE.}
}
\value{
A data frame (table) with results similar to 
HaploReg uses.
}
\description{
This function queries HaploReg web-based tool and returns results.
}
\examples{
library(haploR)
data <- queryHaploreg(c("rs10048158","rs4791078"))
head(data)
}
