% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-hbr.R
\docType{methods}
\name{inspect_window,hbr-method}
\alias{inspect_window}
\alias{inspect_window,hbr-method}
\alias{inspect_window.hbr}
\title{Haplotype-block marker inspection for a window}
\usage{
\S4method{inspect_window}{hbr}(object, window, colCluster = T)
}
\arguments{
\item{object}{object of class \code{\link{hbr}} containing the results of 
reconstructed haplotype-blocks}

\item{window}{number of the window, which should be inspected}

\item{colCluster}{boolean value indicating whether columns in the output
correlation plot should be clustered or the original positions of the 
markers reflecting genomic positions should be kept.}
}
\description{
Plots correlations and groupings of haplotype-markers for a given window
}
\details{
The plotting method operates on \code{\link{hbr}} objects. For a 
specified window the correlation matrix for identified haplotype-block markers
in this window is visualized also indicating haplotype-block identity.
}
\author{
Susanne U. Franssen
}
\seealso{
\code{\link{hbr}} \code{\link{ex_dat}} \code{\link{summary.hbr}} \code{\link{plot.hbr}} 
\code{\link{plot_cluster_trajectories}} \code{\link{plot_marker_trajectories}}
\code{\link{map}} \code{\link{rev_map}} \code{\link{markers}} \code{\link{plot_hbr_freq}}
\code{\link{inspect_window_PCA}} \code{\link{inspect_window_avLink}}
\code{\link{inspect_window_dbScan}} \code{\link{number_hbr}}
}

