### class Parsimnet, functions and methods
##march 2015, cnrakt
##function .TempletonProb is taken from package pegas version 0.6, authors Emmanuel Paradis, Klaus Schliep.


#internal function: calculate steplimit

steplimit<-function(seqlength,prob=.95)
{	
	
# .TempletonProb is taken from package pegas version 0.6, authors Emmanuel Paradis, Klaus Schliep.
	.TempletonProb <- function(j, S, b = 2, r = 1)
	{
		br <- b * r
		P <- numeric(max(j))
		L_jm <- function(q, j, m) {
			jm1 <- j - 1
			qonbr <- q/br
			(2*q)^jm1 * (1 - q)^(2*m + 1) * (1 - qonbr) *
			(2 - q*(br + 1)/br)^jm1 *
			(1 - 2*q*(1 - qonbr))
		}
		for (i in seq_along(P)) {
			M <- S - i
			denom <- integrate(L_jm, 0, 1, j = i, m = M)$value
## eq.7 from Templeton et al. 1992:
			out <- integrate(function(q) q*L_jm(q, j = i, m = M), 0, 1)$value/denom
			P[i] <- 1 - out
		}
		cumprod(P)[j]
	}
	
	i<-1
	test<-1
	testvec<-NULL
	while(test>=prob)
	{
		test<-.TempletonProb(i,seqlength)
		i<-i+1
		testvec<-c(testvec,test)
		
	}
	testvec<-testvec[-(i-1)]
	
	return(testvec)
}



#internal function: tryconnect 

tryconnect<-function(dmat,newhapnam,step,prevp,nexp,prevpair,nhap)
{
	
	if(step>1)
	{
		
		dmat<- fillna(dmat,prevpair,prevp,nexp,step)
		temproxhapsobj<-xhaps(dmat,prevpair,prevp,nexp,step,newhapnam,rownames=c(prevp,nexp))
		temprodmat<-temproxhapsobj$d
		temproprevpair<-temproxhapsobj$prevpair
		tempronewhapnam<-nrow(temprodmat)
		
		
		net<-list(d=temprodmat,newhapnam=tempronewhapnam,step=step,prevp=prevp,nexp=nexp,prevpair=temproprevpair)
		
	} else {
		
		net<-list(d=dmat,newhapnam=newhapnam,step=step,prevp=prevp,nexp=nexp,prevpair=prevpair)
		
		
	}
	
	
	return(net)
	
}


#internal function: fillna

fillna<-function(dmat,prevpair,prevp,nexp,step)
{
	nas<-is.na(dmat[nexp,])
	nas[nexp]<-FALSE
	filna<-dmat[prevp,nas]
	filna[is.na(filna)]<-0
	dmat[nas,nexp]<-dmat[nexp,nas]<-filna+step
	
	return(dmat)
	
}

#internal function: xhap

xhaps<-function(dmat,prevpair,prevp,nexp,step,newhapnam,rownames)

{
	
	prevpair<-c(prevpair,nexp)
	prevpair<-prevpair[order(prevpair)]
	
	convec<-dmat[prevp,]
	convec[nexp]<-step
	diffvec<-rep(1,length(convec))
	diffvec[prevp]<-1
	diffvec[nexp]<--1
	convec[prevp]<-0
	tempprevpair<-prevpair
	eskiprevpair<-prevpair
	rownam<-rownames
	
	
	komsi<-numeric(0)
	
	for(s in 1:(step-1))
	{
		
		if(s>1) komsi<-(s-1):1
		addp<-matrix(c(convec+diffvec*s,komsi),1,)
		navec<-matrix(rep(NA,nrow(dmat)),1,)
		addpm<-matrix(addp[,tempprevpair],1,)
		navec[,tempprevpair]<-addpm
		rownames(navec)<-paste(rownam[1],rownam[2],sep="_")
		dmattemp<-rbind(dmat,navec)
		diffmatrix<- t(-dmattemp[newhapnam+1,]+t(dmattemp[-c(newhapnam+1),]))
		reppoi<-apply(abs(diffmatrix),1,sum,na.rm=TRUE)
		
		if(!any(reppoi==0)) 
		{
			
			newhapnam<-newhapnam+1	
			rownames(addp)<-paste(rownam[1],rownam[2],sep="_")
			rownames(addpm)<-rownames(addp)
			dmat<-rbind(dmat,navec)
			dmat<-cbind(dmat,t(cbind(navec,NA)))
			tempprevpair<-c(tempprevpair,newhapnam)
			
		}		
		
	}
	
	list(d=abs(dmat),prevpair=tempprevpair,newhapnam=newhapnam)
	
}


#internal function:calcclust

calcclust<-function(dmat,step=1,startclustnum=1,all=FALSE)
{
	
	
	startpairs<-which(dmat==step,arr.ind=TRUE)
	clustind<-unique(startpairs[,2])
	
	if(length(clustind))
	{
		
		clustmat<-cbind(0,clustind)
		
		initp<-clustind[1]
		rowind<-which(startpairs==initp,arr.ind=TRUE)[,1]
		ind<- unique(c(startpairs[rowind,]))
		clustmat[match(ind,clustmat[,2]),1]<-startclustnum
		
		clustnum<-length(clustind)
		
		if(clustnum==0)
		{ 
			clustmat<-cbind(startclustnum,initp[order(initp)])
			return(as.matrix(clustmat))	
		}
		newclust<-startclustnum
		for(i in 1:clustnum)
		
		{
			hap<-clustind[i]
			rowind<-which(startpairs==hap,arr.ind=TRUE)[,1]
			ind<- unique(c(startpairs[rowind,]))
			checkclass<-clustmat[match(ind,clustmat[,2]),1]		
			if(any(checkclass>0)) 
			{
				cls<-min(checkclass[checkclass>0])
				clustmat[match(ind,clustmat[,2]),1]<-cls
				remcls<-checkclass[checkclass>0&checkclass!=cls]
				if(length(remcls)>0) clustmat[!is.na(match(clustmat[,1],remcls)),1]<-cls
				
				
			} else
			{
				newclust<-newclust+1
				clustmat[match(ind,clustmat[,2]),1]<-newclust
			}
		}
	} else 
	{
		
		clustmat<-matrix(NA,0,2)
	}
	clust<-factor(clustmat[,1])
	newlev<-1:length(unique(clust))
	levels(clust)<-newlev
	clustmat[,1]<-clust
	
	if(length(clustind)>0&all) 
	{
		rem<-setdiff(1:nrow(dmat),clustmat[,2])
		remmat<-matrix(NA,length(rem),2)
		remmat[,2]<-rem
		remmat[,1]<-(1:length(rem))+max(clustmat[,1])
		clustmat<-rbind(clustmat,remmat)
		
	}
	
	
	if(length(clustind)==0&all) 
	{
		rem<-1:nrow(dmat)
		remmat<-matrix(NA,length(rem),2)
		remmat[,2]<-rem
		remmat[,1]<-(1:length(rem))+startclustnum-1
		clustmat<-remmat
		
	}
	
	return(as.matrix(clustmat))
}




#internal function: recdistG

recdistG<-function(d,dmat,clustmat)
{
	
	nhap<-nrow(d)
	tempdmat<-dmat
	tempdmat[1:nhap,1:nhap]<-d
	clusters<-unique(clustmat[,1])
	
	for(i in clusters)
	{
		ind<-clustmat[clustmat[,1]==i,2]
		tempdmat[ind,ind]<-dmat[ind,ind]
	}	
	return(tempdmat)
	
}




#internal function: tryconnectG

tryconnectG<-function(dmat,prevset,nexpset,nhap)
{
	scorevec<-vector("numeric",0)
	parsimscorevec<-vector("numeric",0)
	nexpvec<-vector("numeric",0)
	prevpvec<-vector("numeric",0)
	xvec<-vector("numeric",0)
	jumplist<-vector("list",0)
	
	
	for(i in 1:length(prevset))
	{
		prevp<-prevset[i]
		
		for(j in 1:length(nexpset))
		{
			
			nexp<-nexpset[j]
			nexpvec<-c(nexpvec,nexp)
			prevpvec<-c(prevpvec,prevp)
			
			if(prevp<=nhap)
			{
				if(nexp<=nhap)
				{
					
					x<-dmat[prevp,nexp,drop=FALSE]
					jump<-dmat
					jump[nexp,prevset]<-jump[prevset,nexp]<-jump[prevp,prevset]+x
					jump[nexp,prevp]<-jump[prevp,nexp]<-x
					if(length(nexpset)>1)
					{
						remmat<-matrix(jump[nexp,prevset],length(nexpset[-j]),length(prevset),byrow=TRUE)+jump[nexpset[-j],nexp]
						jump[nexpset[-j],prevset]<-remmat
						jump[prevset,nexpset[-j]]<-t(remmat)
					}
					test<-jump[nexpset[nexpset<=nhap], prevset[prevset<=nhap]]-dmat[nexpset[nexpset<=nhap], prevset[prevset<=nhap]]
					score<-sum(test)
					parssc<-x+sum(jump==1,na.rm=TRUE)/2
					
					if(any(test<0,na.rm=TRUE))
					{
						score<-Inf
						parssc<-Inf
					}
					parsimscorevec<-c(parsimscorevec,parssc)
					scorevec<-c(scorevec,score)
					xvec<-c(xvec,x)
					jumplist<-c(jumplist,list(jump[nexpset, prevset]))			
				}
				
				if(nexp>nhap)
				{
					
					minkomsi<-which.min(dmat[nexp,nexpset[nexpset<=nhap]])
					komsi<-nexpset[nexpset<=nhap][minkomsi]
					x<- dmat[prevp,komsi]-dmat[nexp,komsi]
					jump<-dmat
					jump[nexp,prevset]<-jump[prevset,nexp]<-jump[prevp,prevset]+x
					jump[nexp,prevp]<-jump[prevp,nexp]<-x
					if(length(nexpset)>1)
					{
						remmat<-matrix(jump[nexp,prevset],length(nexpset[-j]),length(prevset),byrow=TRUE)+jump[nexpset[-j],nexp]
						jump[nexpset[-j],prevset]<-remmat
						jump[prevset,nexpset[-j]]<-t(remmat)
					}
					test<-jump[nexpset[nexpset<=nhap], prevset[prevset<=nhap]]-dmat[nexpset[nexpset<=nhap], prevset[prevset<=nhap]]
					score<-sum(test)
					parssc<-x+sum(jump==1,na.rm=TRUE)/2
					
					if(any(test<0,na.rm=TRUE))
					{
						score<-Inf
						parssc<-Inf
					}
					parsimscorevec<-c(parsimscorevec,parssc)
					scorevec<-c(scorevec,score)
					xvec<-c(xvec,x)
					jumplist<-c(jumplist,list(jump[nexpset, prevset]))
				}
			}
			
			
			if(prevp>nhap)
			{
				if(nexp<=nhap)
				{
					minkomsi<-which.min(dmat[prevp,prevset[prevset<=nhap]])
					komsi<-prevset[prevset<=nhap][minkomsi]
					x<- dmat[nexp,komsi]-dmat[prevp,komsi]
					jump<-dmat
					jump[nexp,prevset]<-jump[prevset,nexp]<-jump[prevp,prevset]+x
					jump[nexp,prevp]<-jump[prevp,nexp]<-x
					if(length(nexpset)>1)
					{
						remmat<-matrix(jump[nexp,prevset],length(nexpset[-j]),length(prevset),byrow=TRUE)+jump[nexpset[-j],nexp]
						jump[nexpset[-j],prevset]<-remmat
						jump[prevset,nexpset[-j]]<-t(remmat)
					}
					test<-jump[nexpset[nexpset<=nhap], prevset[prevset<=nhap]]-dmat[nexpset[nexpset<=nhap], prevset[prevset<=nhap]]
					score<-sum(test)
					parssc<-x+sum(jump==1,na.rm=TRUE)/2
					
					if(any(test<0,na.rm=TRUE))
					{
						score<-Inf
						parssc<-Inf
					}
					parsimscorevec<-c(parsimscorevec,parssc)
					scorevec<-c(scorevec,score)
					xvec<-c(xvec,x)
					jumplist<-c(jumplist,list(jump[nexpset, prevset]))
				}
				
				
				
				
				if(nexp>nhap)
				{
					minkomsiP<-which.min(dmat[prevp,prevset[prevset<=nhap]])
					komsiP<-prevset[prevset<=nhap][minkomsiP]
					minkomsiN<-which.min(dmat[nexp,nexpset[nexpset<=nhap]])
					komsiN<-nexpset[nexpset<=nhap][minkomsiN]
					x<- dmat[komsiN,komsiP] - dmat[prevp,komsiP]- dmat[nexp,komsiN]
					jump<-dmat
					jump[nexp,prevset]<-jump[prevset,nexp]<-jump[prevp,prevset]+x
					jump[nexp,prevp]<-jump[prevp,nexp]<-x
					if(length(nexpset)>1)
					{
						remmat<-matrix(jump[nexp,prevset],length(nexpset[-j]),length(prevset),byrow=TRUE)+jump[nexpset[-j],nexp]
						jump[nexpset[-j],prevset]<-remmat
						jump[prevset,nexpset[-j]]<-t(remmat)
					}
					test<-jump[nexpset[nexpset<=nhap], prevset[prevset<=nhap]]-dmat[nexpset[nexpset<=nhap], prevset[prevset<=nhap]]
					score<-sum(test)
					parssc<-x+sum(jump==1,na.rm=TRUE)/2
					
					if(any(test<0,na.rm=TRUE))
					{
						score<-Inf
						parssc<-Inf
					}
					parsimscorevec<-c(parsimscorevec,parssc)
					scorevec<-c(scorevec,score)
					xvec<-c(xvec,x)
					jumplist<-c(jumplist,list(jump[nexpset, prevset]))
					
				}
				
				
				
			}
			
			
			
		}
		
		
		
	}
	
	
	minnetlen<-min(parsimscorevec)
	maxpar<-which(parsimscorevec==minnetlen)
	best<-maxpar[which.min(scorevec[maxpar])]
	
	return(list(scorevec=scorevec[best],parsimvec=parsimscorevec[best],prevpvec=prevpvec[best],nexpvec=nexpvec[best],xvec=xvec[best],jump=jumplist[best]))
	
}


#internal function: clustersG

clustersG<-function(d,connumber,nhap)
{
	
	dmat<-d
	clustmat<- calcclust(dmat,1,1,all=TRUE)
	clusters<-unique(clustmat[,1])
	if(length(clusters)==1) loop<-FALSE else loop<-TRUE
	
	while(loop)
	
	{
		
		
		dmat<-recdistG(d,dmat,clustmat)
		tempdmat<-dmat
		newhapnam<-nrow(dmat)
		clusters<-unique(clustmat[,1])
		clustcombn<-combn(clusters,2)
		scorevec<-vector("numeric",0)
		parsimvec<-vector("numeric",0)
		prevpvec<-vector("numeric",0)
		nexpvec<-vector("numeric",0)
		xvec<-vector("numeric",0)	
		nexpsetlist<-vector("list",0)
		prevsetlist<-vector("list",0)
		jumplist<-vector("list",0)
		
		for(k in 1:ncol(clustcombn))
		
		{
			ind<-clustcombn[,k]
			size1<-sum(clustmat[,1]==ind[1])
			size2<-sum(clustmat[,1]==ind[2])
			if(size1>size2)
			{ 
				clA<-clustmat[clustmat[,1]==ind[2],2]
				clB<-clustmat[clustmat[,1]==ind[1],2]
			}
			
			if(size1<=size2)
			{
				clA<-clustmat[clustmat[,1]==ind[1],2]
				clB<-clustmat[clustmat[,1]==ind[2],2]
			}
			
			nexpset<-clA
			prevset<-clB
			trG.obj<-tryconnectG(dmat,prevset,nexpset,nhap)
			scorevec<-c(scorevec,trG.obj$scorevec)
			parsimvec<-c(parsimvec,trG.obj$parsimvec)
			prevpvec<-c(prevpvec,trG.obj$prevpvec)	
			nexpvec<-c(nexpvec,trG.obj$nexpvec)		
			xvec<-c(xvec,trG.obj$xvec)
			nexpsetlist<-c(nexpsetlist,list(nexpset))
			prevsetlist<-c(prevsetlist,list(prevset))
			jumplist<-c(jumplist,trG.obj$jump)
			
		}		
		
		allowedcon<-xvec<=connumber
		
		
		if(any(allowedcon))
		{
			scorevec<-scorevec[allowedcon]
			parsimvec<-parsimvec[allowedcon]
			prevpvec<-prevpvec[allowedcon]
			nexpvec<-nexpvec[allowedcon]
			xvec<-xvec[allowedcon]
			nexpsetlist<-nexpsetlist[allowedcon]
			prevsetlist<-prevsetlist[allowedcon]
			jumplist<-jumplist[allowedcon]
			minnetlen<-min(parsimvec)
			maxpar<-which(parsimvec==minnetlen)
			best<-maxpar[which.min(scorevec[maxpar])]
			prevset<-prevsetlist[[best]]
			nexpset<-nexpsetlist[[best]]
			prevp<-prevpvec[best]
			nexp<-nexpvec[best]	
			x<-xvec[best]
			jump<-jumplist[[best]]
			
			
			tempdmat[nexpset,prevset]<-jump
			tempdmat[prevset,nexpset]<-t(jump)
			
			
			if(x>1) 
			{ 
				
				tempnet<-tryconnect(tempdmat,newhapnam,step=x,prevp=prevp,nexp,c(nexp,prevp),nhap)
				tempdmat<-tempnet$d
				newhaps<-(nrow(dmat)+1):nrow(tempdmat)
				
				remprevpset<-prevset[!prevset==prevp]
				
				if(length(remprevpset)>0)
				{
					
					addh<-tempdmat[prevp,remprevpset]
					addxh<-tempdmat[prevp,newhaps]
					recdmat<-matrix(addxh,length(addh),length(addxh),byrow=TRUE)+addh
					
					tempdmat[remprevpset,newhaps]<-recdmat
					tempdmat[newhaps,remprevpset]<-t(recdmat)
				}
				remnexpset<-nexpset[!nexpset==nexp]
				
				if(length(remnexpset)>0)
				{
					
					addh<-tempdmat[nexp,remnexpset]
					addxh<-tempdmat[nexp,newhaps]
					recdmat<-matrix(addxh,length(addh),length(addxh),byrow=TRUE)+addh
					
					tempdmat[remnexpset,newhaps]<-recdmat
					tempdmat[newhaps,remnexpset]<-t(recdmat)
				}
			}
			
			dmat<-tempdmat
			clustmat<- calcclust(dmat,1,1,all=TRUE)
		}
		
		if(!any(allowedcon)|all(clustmat[,1]==1)) loop<-FALSE
		
	}
	
	return(dmat)
}




#internal function: parsnet

parsnet<-function(d,seqlength,prob=.95)

{
	
	d<-as.matrix(d)
	diag(d)<-NA
	rwnd<-rownames(d)
	if(is.null(rwnd)) rownames(d)<-1:nrow(d)
	tempprobs<-steplimit(seqlength,prob)
	conlim<-length(tempprobs)
	nhap<-nrow(d)
	dmat<-clustersG(d,conlim,nhap)
	clusters<-calcclust(dmat,1,1,all=TRUE)
	nhaps<-vector("numeric",0)
	if(all(clusters[,1]==1))
	{
		nm<-paste("net",1,sep="")
		grouplist<-list(1:nrow(dmat))
		dmatlist<-list(dmat)
		names(grouplist)<-nm
		names(dmatlist)<-nm
		return(list(d=dmatlist,tempProbs=tempprobs,conlimit=conlim,nhap=nhap,rowindex=grouplist))	
	} else {
		
		cl<-unique(clusters[,1])
		dmatlist<-vector("list",length(cl))
		grouplist<-vector("list",length(cl))
		for(i in 1: length(cl))
		{
			
			group<-clusters[clusters[,1]==cl[i],2]
			grouplist[[i]]<-group
			
			dmatlist[[i]]<-dmat[group,group,drop=FALSE]
			nhaps<-c(nhaps,length(group[group<=nhap]))
		}
		nm<-paste("net",1:length(cl),sep="")
		names(grouplist)<-nm
		names(dmatlist)<-nm
		
		return(list(d=dmatlist,tempProbs=tempprobs,conlimit=conlim,nhap=nhaps,rowindex=grouplist))
	}
	
	
}


#class Parsimnet

setClass(Class="Parsimnet", representation=representation(d="list",tempProbs="numeric",conlimit="numeric",prob="numeric",nhap="numeric",rowindex="list"))



#Set initialize Class Haplotype
setMethod("initialize", "Parsimnet", function(.Object,d=list(),tempProbs=numeric(0),conlimit=numeric(0),prob=numeric(0), nhap=numeric(0),rowindex=list()) 
{
	.Object@d<-d
	.Object@tempProbs<-tempProbs
	.Object@conlimit<-conlimit
	.Object@prob<-prob
	.Object@nhap<-nhap
	.Object@rowindex<-rowindex
	.Object
})


#Show method for Dna objects
setMethod("show","Parsimnet", function(object)
{
	
	cat("*** S4 Object of Class Parsimnet ***\n\n")
	cat("\nNumber of networks: \n")
	cat(length(object@d),"\n")
	cat("\nCalculated maximum connection steps at",100*object@prob,"%:","\n")
	cat(object@conlimit,"\n")
	cat("\nNumber of haplotypes in each network: \n")
	cat(object@nhap,"\n")
	cat("\nNumber of intermediates in each network: \n")
	cat(sapply(object@d,nrow)-object@nhap,"\n")
	cat("\nScore of each network (total network lengths): \n")
	cat(length(object),"\n")
	cat("\n\nslots of an object Parsimnet:\n", slotNames(object))
	
	
})




#Generic parsimnet

setGeneric (
name= "parsimnet",
def=function(x,...)standardGeneric("parsimnet")
)


#parsimnet method for Dna objects 

setMethod(f="parsimnet", signature= "Dna", definition=function(x,indels="sic",prob=.95)
{
	
	if(length(prob)>1|| (prob<=0|prob>=1)) stop("probability must be numeric vector of length 1, in the range (0,1)")
	h<-haplotype(x,indels=indels)
	d<-h@d
	netw<-parsnet(d,x@seqlengths[1],prob=prob)
	new("Parsimnet",d=netw$d,tempProbs=netw$tempProbs,conlimit=netw$conlimit,prob=prob, nhap=netw$nhap,rowindex=netw$rowindex)
}
)



#parsimnet method for matrix objects 

setMethod(f="parsimnet", signature= "matrix", definition=function(x,seqlength,prob=.95)
{
	
	if(length(prob)>1|| (prob<=0|prob>=1)) stop("probability must be numeric vector of length 1, in the range (0,1)")
	h<-haplotype(x)
	d<-h@d
	netw<-parsnet(d,seqlength=seqlength,prob=prob)
	new("Parsimnet",d=netw$d,tempProbs=netw$tempProbs,conlimit=netw$conlimit,prob=prob,nhap=netw$nhap,rowindex=netw$rowindex)
	
}
)



#parsimnet method for dist objects 

setMethod(f="parsimnet", signature= "dist", definition=function(x,seqlength,prob=.95)
{
	if(length(prob)>1|| (prob<=0|prob>=1)) stop("probability must be numeric vector of length 1, in the range (0,1)")
	h<-haplotype(x)
	d<-h@d
	netw<-parsnet(d,seqlength=seqlength,prob=prob)
	new("Parsimnet",d=netw$d,tempProbs=netw$tempProbs,conlimit=netw$conlimit,prob=prob,nhap=netw$nhap,rowindex=netw$rowindex)	
}
)



#plot method for Parsimnet objects 

setMethod(f="plot", signature= "Parsimnet", definition=function(x,net=1,inter.labels=FALSE,...)
{
	
	dots <- list(...)
	arg<-names(dots)
	netnum<-length(x@d)
	i<-net
	netd<-x@d
	nm<-names(netd)[i]
	net<-netd[[i]]
	nhap<-x@nhap[i]
	rn<-rownames(net)
	net[net!=1]<-0
	if(nrow(net)==1) net[is.na(net)]<-1
	g<-network(net)
	if(!inter.labels&&(length(rn)>nhap)) rn[(nhap+1):length(rn)]<-NA
	if(!any(arg=="label")) dots$label<-rn		
	if(!any(arg=="usearrows")) dots$usearrows <- FALSE
	if(nrow(net)>1) { if(!any(arg=="mode")) dots$mode<-"kamadakawai" } else   if(!any(arg=="mode")) dots$mode<-"circle"
	if(!any(arg=="pad")) dots$pad <- 1
	if(!any(arg=="label.cex")) dots$label.cex<-0.75
	if(!any(arg=="vertex.cex")) dots$vertex.cex <- c(rep(0.8,nhap),rep(0.5,nrow(net)-nhap))
	if(!any(arg=="vertex.col"))dots$vertex.col<-c(rep(2,nhap),rep(4,nrow(net)-nhap))
	args <- c(list(x = g),c(dots,list(main=nm)))
	do.call(plot, args)
		
}
)



#length method for Parsimnet objects 

setMethod(f="length", signature= "Parsimnet", definition=function(x)
{
	
	netnum<-length(x@d)
	lvec<-vector("numeric",netnum)
	for(i in 1:netnum)
	{
		net<-x@d[[i]]
		lvec[i]<-sum(net==1,na.rm=TRUE)/2
	}
	lvec
}
)


#Coerce Parsimnet object to a list

setMethod("as.list","Parsimnet", function(x) 
{
	l<-list(x@d,x@tempProbs, x@conlimit,x@prob,x@nhap,x@rowindex)
	names(l)<-c("d","tempProbs","conlimit","prob","nhap","rowindex")
	l	
})

