% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_layers_metadata.R
\name{get_layers_metadata}
\alias{get_layers_metadata}
\title{Metadata for one couple of apikey and data_type}
\usage{
get_layers_metadata(data_type, apikey = NULL)
}
\arguments{
\item{data_type}{Should be \code{"wfs"}, \code{"wms-r"} or \code{"wmts"}. See details for more
information about these Web services formats.}

\item{apikey}{API key from \code{get_apikeys()} or directly from the
\href{https://geoservices.ign.fr/services-web-experts}{IGN website}}
}
\value{
data.frame
}
\description{
Metadata are retrieved using the IGN APIs. The execution time can
be long depending on the size of the metadata associated with
the API key and the overload of the IGN servers.
}
\details{
\itemize{
\item \code{"wfs"} : Web Feature Service designed to return data in vector format (line,
point, polygon, ...) ;
\item \code{"wms-r"} : Web Map Service focuses on raster data ;
\item \code{"wmts"} : Web Map Tile Service is similar to WMS, but instead of serving maps
as single images, WMTS serves maps by dividing the map into a pyramid of tiles at
multiple scales.
}
}
\examples{
\dontrun{
# Get all metadata for a datatype
metadata_table <- get_layers_metadata("wms-r")

# Get all "administratif" wms layers
apikey <- get_apikeys()[1] #administratif
admin_layers <- get_layers_metadata("wms-r", apikey)

}

}
\seealso{
\code{\link[=get_apikeys]{get_apikeys()}}
}
