% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_cf_lr.R
\name{hcp_cf_lr}
\alias{hcp_cf_lr}
\title{Change Finder using LR}
\usage{
hcp_cf_lr(sw_size = 30)
}
\arguments{
\item{sw_size}{Sliding window size}
}
\value{
\code{hcp_cf_lr} object
}
\description{
Change-point detection is related to event/trend change detection. Change Finder LR detects change points based on deviations relative to linear regression model \url{doi:10.1109/TKDE.2006.1599387}.
}
\examples{
library(daltoolbox)

#loading the example database
data(examples_changepoints)

#Using simple example
dataset <- examples_changepoints$simple
head(dataset)

# setting up change point method
model <- hcp_cf_lr()

# fitting the model
model <- fit(model, dataset$serie)

detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
