% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blueprint-formula.R, R/blueprint-recipe.R,
%   R/blueprint-xy.R, R/blueprint.R
\name{new_formula_blueprint}
\alias{new_formula_blueprint}
\alias{new_recipe_blueprint}
\alias{new_xy_blueprint}
\alias{new-blueprint}
\alias{new_blueprint}
\title{Create a new preprocessing blueprint}
\usage{
new_formula_blueprint(
  intercept = FALSE,
  allow_novel_levels = FALSE,
  ptypes = NULL,
  formula = NULL,
  indicators = "traditional",
  composition = "tibble",
  ...,
  subclass = character()
)

new_recipe_blueprint(
  intercept = FALSE,
  allow_novel_levels = FALSE,
  fresh = TRUE,
  strings_as_factors = TRUE,
  composition = "tibble",
  ptypes = NULL,
  recipe = NULL,
  ...,
  subclass = character()
)

new_xy_blueprint(
  intercept = FALSE,
  allow_novel_levels = FALSE,
  composition = "tibble",
  ptypes = NULL,
  ...,
  subclass = character()
)

new_blueprint(
  intercept = FALSE,
  allow_novel_levels = FALSE,
  composition = "tibble",
  ptypes = NULL,
  ...,
  subclass = character()
)
}
\arguments{
\item{intercept}{A logical. Should an intercept be included in the
processed data? This information is used by the \code{process} function
in the \code{mold} and \code{forge} function list.}

\item{allow_novel_levels}{A logical. Should novel factor levels be allowed at
prediction time? This information is used by the \code{clean} function in the
\code{forge} function list, and is passed on to \code{\link[=scream]{scream()}}.}

\item{ptypes}{Either \code{NULL}, or a named list with 2 elements, \code{predictors}
and \code{outcomes}, both of which are 0-row tibbles. \code{ptypes} is generated
automatically at \code{\link[=mold]{mold()}} time and is used to validate \code{new_data} at
prediction time.}

\item{formula}{Either \code{NULL}, or a formula that specifies how the
predictors and outcomes should be preprocessed. This argument is set
automatically at \code{\link[=mold]{mold()}} time.}

\item{indicators}{A single character string. Control how factors are
expanded into dummy variable indicator columns. One of:
\itemize{
\item \code{"traditional"} - The default. Create dummy variables using the
traditional \code{\link[=model.matrix]{model.matrix()}} infrastructure. Generally this creates
\code{K - 1} indicator columns for each factor, where \code{K} is the number of
levels in that factor.
\item \code{"none"} - Leave factor variables alone. No expansion is done.
\item \code{"one_hot"} - Create dummy variables using a one-hot encoding approach
that expands unordered factors into all \code{K} indicator columns, rather than
\code{K - 1}.
}}

\item{composition}{Either "tibble", "matrix", or "dgCMatrix" for the format
of the processed predictors. If "matrix" or "dgCMatrix" are chosen, all of
the predictors must be numeric after the preprocessing method has been
applied; otherwise an error is thrown.}

\item{...}{Name-value pairs for additional elements of blueprints that
subclass this blueprint.}

\item{subclass}{A character vector. The subclasses of this blueprint.}

\item{fresh}{Should already trained operations be re-trained when \code{prep()} is
called?}

\item{strings_as_factors}{Should character columns be converted to factors
when \code{prep()} is called?}

\item{recipe}{Either \code{NULL}, or an unprepped recipe. This argument is set
automatically at \code{\link[=mold]{mold()}} time.}
}
\value{
A preprocessing blueprint, which is a list containing the inputs used as
arguments to the function, along with a class specific to the type
of blueprint being created.
}
\description{
These are the base classes for creating new preprocessing blueprints. All
blueprints inherit from the one created by \code{new_blueprint()}, and the default
method specific blueprints inherit from the other three here.

If you want to create your own processing blueprint for a specific method,
generally you will subclass one of the method specific blueprints here. If
you want to create a completely new preprocessing blueprint for a totally new
preprocessing method (i.e. not the formula, xy, or recipe method) then
you should subclass \code{new_blueprint()}.

In addition to creating a blueprint subclass, you will likely also need to
provide S3 methods for \code{\link[=run_mold]{run_mold()}} and \code{\link[=run_forge]{run_forge()}} for your subclass.
}
