% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_instruments.R
\name{match_instruments}
\alias{match_instruments}
\title{Match Instruments Function}
\usage{
match_instruments(instruments)
}
\arguments{
\item{instruments}{A list of instruments to be matched.}
}
\value{
A list of matched instruments returned from the 'Harmony Data API'.
}
\description{
This function takes a list of instruments, converts it to a format acceptable by the database,
and matches the instruments using the 'Harmony Data API'. It returns the matched instruments.
}
\examples{
\donttest{
instruments_list <- list(
  list(
    instrument_id = "id1",
    instrument_name = "Instrument A",
    questions = list(
      list(
        question_text = "How old are you?",
        topics = c("Age", "Demographics"),
        source_page = "https://example.com/instrumentA"
      ),
      list(
        question_text = "What is your gender?",
        topics = c("Gender", "Demographics"),
        source_page = "https://example.com/instrumentA"
      )
    )
  ),
  list(
    instrument_id = "id2",
    instrument_name = "Instrument B",
    questions = list(
      list(
        question_text = "Do you smoke?",
        topics = c("Smoking", "Health"),
        source_page = "https://example.com/instrumentB"
      )
    )
  )
)
matched_instruments <- match_instruments(instruments_list)

}

}
\references{
For more information about the 'Harmony Data API', visit: \url{https://api.harmonydata.org/docs}
}
\author{
Ulster University [cph]
}
