// Generated by rstantools.  Do not edit by hand.

/*
    hbamr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hbamr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hbamr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_HBAM_R_MINI_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'HBAM_R_MINI', line 28, column 2 to column 25)",
                                                      " (in 'HBAM_R_MINI', line 29, column 2 to column 24)",
                                                      " (in 'HBAM_R_MINI', line 30, column 2 to column 22)",
                                                      " (in 'HBAM_R_MINI', line 31, column 2 to column 26)",
                                                      " (in 'HBAM_R_MINI', line 32, column 2 to column 30)",
                                                      " (in 'HBAM_R_MINI', line 33, column 2 to column 40)",
                                                      " (in 'HBAM_R_MINI', line 34, column 2 to column 22)",
                                                      " (in 'HBAM_R_MINI', line 35, column 2 to column 25)",
                                                      " (in 'HBAM_R_MINI', line 36, column 2 to column 22)",
                                                      " (in 'HBAM_R_MINI', line 37, column 2 to column 44)",
                                                      " (in 'HBAM_R_MINI', line 38, column 2 to column 24)",
                                                      " (in 'HBAM_R_MINI', line 39, column 2 to column 24)",
                                                      " (in 'HBAM_R_MINI', line 40, column 2 to column 47)",
                                                      " (in 'HBAM_R_MINI', line 43, column 2 to column 22)",
                                                      " (in 'HBAM_R_MINI', line 44, column 2 to column 22)",
                                                      " (in 'HBAM_R_MINI', line 45, column 2 to column 22)",
                                                      " (in 'HBAM_R_MINI', line 46, column 2 to column 21)",
                                                      " (in 'HBAM_R_MINI', line 47, column 2 to column 16)",
                                                      " (in 'HBAM_R_MINI', line 48, column 2 to column 24)",
                                                      " (in 'HBAM_R_MINI', line 49, column 2 to column 77)",
                                                      " (in 'HBAM_R_MINI', line 50, column 2 to column 20)",
                                                      " (in 'HBAM_R_MINI', line 51, column 2 to column 25)",
                                                      " (in 'HBAM_R_MINI', line 52, column 2 to column 25)",
                                                      " (in 'HBAM_R_MINI', line 53, column 2 to column 45)",
                                                      " (in 'HBAM_R_MINI', line 54, column 2 to column 45)",
                                                      " (in 'HBAM_R_MINI', line 55, column 2 to column 47)",
                                                      " (in 'HBAM_R_MINI', line 56, column 2 to column 48)",
                                                      " (in 'HBAM_R_MINI', line 58, column 4 to column 63)",
                                                      " (in 'HBAM_R_MINI', line 59, column 4 to column 63)",
                                                      " (in 'HBAM_R_MINI', line 60, column 4 to line 61, column 84)",
                                                      " (in 'HBAM_R_MINI', line 62, column 4 to line 63, column 84)",
                                                      " (in 'HBAM_R_MINI', line 64, column 4 to line 65, column 84)",
                                                      " (in 'HBAM_R_MINI', line 66, column 4 to line 67, column 84)",
                                                      " (in 'HBAM_R_MINI', line 68, column 4 to column 40)",
                                                      " (in 'HBAM_R_MINI', line 57, column 21 to line 69, column 3)",
                                                      " (in 'HBAM_R_MINI', line 57, column 2 to line 69, column 3)",
                                                      " (in 'HBAM_R_MINI', line 93, column 2 to column 53)",
                                                      " (in 'HBAM_R_MINI', line 94, column 2 to column 74)",
                                                      " (in 'HBAM_R_MINI', line 95, column 2 to column 71)",
                                                      " (in 'HBAM_R_MINI', line 96, column 2 to column 88)",
                                                      " (in 'HBAM_R_MINI', line 72, column 2 to column 27)",
                                                      " (in 'HBAM_R_MINI', line 73, column 2 to column 26)",
                                                      " (in 'HBAM_R_MINI', line 74, column 2 to column 32)",
                                                      " (in 'HBAM_R_MINI', line 75, column 2 to column 32)",
                                                      " (in 'HBAM_R_MINI', line 76, column 2 to column 49)",
                                                      " (in 'HBAM_R_MINI', line 77, column 2 to column 31)",
                                                      " (in 'HBAM_R_MINI', line 78, column 2 to column 31)",
                                                      " (in 'HBAM_R_MINI', line 79, column 2 to column 28)",
                                                      " (in 'HBAM_R_MINI', line 80, column 2 to column 29)",
                                                      " (in 'HBAM_R_MINI', line 81, column 2 to column 25)",
                                                      " (in 'HBAM_R_MINI', line 82, column 2 to column 25)",
                                                      " (in 'HBAM_R_MINI', line 83, column 2 to column 24)",
                                                      " (in 'HBAM_R_MINI', line 84, column 2 to column 33)",
                                                      " (in 'HBAM_R_MINI', line 85, column 2 to column 30)",
                                                      " (in 'HBAM_R_MINI', line 86, column 2 to column 27)",
                                                      " (in 'HBAM_R_MINI', line 90, column 4 to column 42)",
                                                      " (in 'HBAM_R_MINI', line 88, column 4 to column 27)",
                                                      " (in 'HBAM_R_MINI', line 87, column 2 to line 90, column 42)",
                                                      " (in 'HBAM_R_MINI', line 2, column 2 to column 19)",
                                                      " (in 'HBAM_R_MINI', line 3, column 2 to column 19)",
                                                      " (in 'HBAM_R_MINI', line 4, column 2 to column 23)",
                                                      " (in 'HBAM_R_MINI', line 5, column 8 to column 13)",
                                                      " (in 'HBAM_R_MINI', line 5, column 2 to column 33)",
                                                      " (in 'HBAM_R_MINI', line 6, column 8 to column 13)",
                                                      " (in 'HBAM_R_MINI', line 6, column 2 to column 33)",
                                                      " (in 'HBAM_R_MINI', line 7, column 2 to column 19)",
                                                      " (in 'HBAM_R_MINI', line 8, column 2 to column 30)",
                                                      " (in 'HBAM_R_MINI', line 9, column 2 to column 30)",
                                                      " (in 'HBAM_R_MINI', line 10, column 8 to column 13)",
                                                      " (in 'HBAM_R_MINI', line 10, column 2 to column 44)",
                                                      " (in 'HBAM_R_MINI', line 11, column 8 to column 13)",
                                                      " (in 'HBAM_R_MINI', line 11, column 2 to column 44)",
                                                      " (in 'HBAM_R_MINI', line 12, column 8 to column 9)",
                                                      " (in 'HBAM_R_MINI', line 12, column 2 to column 40)",
                                                      " (in 'HBAM_R_MINI', line 13, column 2 to column 27)",
                                                      " (in 'HBAM_R_MINI', line 14, column 31 to column 36)",
                                                      " (in 'HBAM_R_MINI', line 14, column 2 to column 46)",
                                                      " (in 'HBAM_R_MINI', line 17, column 2 to column 64)",
                                                      " (in 'HBAM_R_MINI', line 18, column 2 to column 55)",
                                                      " (in 'HBAM_R_MINI', line 19, column 31 to column 36)",
                                                      " (in 'HBAM_R_MINI', line 19, column 2 to column 64)",
                                                      " (in 'HBAM_R_MINI', line 20, column 32 to column 33)",
                                                      " (in 'HBAM_R_MINI', line 20, column 2 to column 55)",
                                                      " (in 'HBAM_R_MINI', line 21, column 11 to column 16)",
                                                      " (in 'HBAM_R_MINI', line 21, column 2 to column 48)",
                                                      " (in 'HBAM_R_MINI', line 23, column 4 to column 45)",
                                                      " (in 'HBAM_R_MINI', line 24, column 4 to column 45)",
                                                      " (in 'HBAM_R_MINI', line 22, column 21 to line 25, column 3)",
                                                      " (in 'HBAM_R_MINI', line 22, column 2 to line 25, column 3)",
                                                      " (in 'HBAM_R_MINI', line 28, column 9 to column 10)",
                                                      " (in 'HBAM_R_MINI', line 29, column 9 to column 10)",
                                                      " (in 'HBAM_R_MINI', line 31, column 8 to column 9)",
                                                      " (in 'HBAM_R_MINI', line 35, column 9 to column 10)",
                                                      " (in 'HBAM_R_MINI', line 37, column 8 to column 9)",
                                                      " (in 'HBAM_R_MINI', line 40, column 31 to column 40)",
                                                      " (in 'HBAM_R_MINI', line 44, column 8 to column 9)",
                                                      " (in 'HBAM_R_MINI', line 45, column 9 to column 10)",
                                                      " (in 'HBAM_R_MINI', line 46, column 9 to column 10)",
                                                      " (in 'HBAM_R_MINI', line 48, column 9 to column 14)",
                                                      " (in 'HBAM_R_MINI', line 49, column 31 to column 32)",
                                                      " (in 'HBAM_R_MINI', line 93, column 9 to column 10)",
                                                      " (in 'HBAM_R_MINI', line 94, column 9 to column 10)",
                                                      " (in 'HBAM_R_MINI', line 95, column 9 to column 10)",
                                                      " (in 'HBAM_R_MINI', line 96, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_HBAM_R_MINI final : public model_base_crtp<model_HBAM_R_MINI> {
private:
  int N;
  int J;
  int N_obs;
  std::vector<int> ii;
  std::vector<int> jj;
  int B;
  int L;
  int R;
  std::vector<int> Y;
  std::vector<double> U;
  std::vector<int> V;
  int CV;
  Eigen::Matrix<double, -1, 1> holdout;
  double sigma_alpha_prior_rate;
  double tau_prior_rate;
  Eigen::Matrix<double, -1, 1> not_holdout;
  Eigen::Matrix<double, -1, 1> Vvec;
  std::vector<std::vector<double>> p;
  int zeta_1dim__;
 
public:
  ~model_HBAM_R_MINI() { }
  
  inline std::string model_name() const final { return "model_HBAM_R_MINI"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_HBAM_R_MINI(stan::io::var_context& context__,
                    unsigned int random_seed__ = 0,
                    std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_HBAM_R_MINI_namespace::model_HBAM_R_MINI";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 59;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 59;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 59;
      current_statement__ = 59;
      check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 60;
      context__.validate_dims("data initialization","J","int",
          context__.to_vec());
      J = std::numeric_limits<int>::min();
      
      current_statement__ = 60;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 60;
      current_statement__ = 60;
      check_greater_or_equal(function__, "J", J, 1);
      current_statement__ = 61;
      context__.validate_dims("data initialization","N_obs","int",
          context__.to_vec());
      N_obs = std::numeric_limits<int>::min();
      
      current_statement__ = 61;
      N_obs = context__.vals_i("N_obs")[(1 - 1)];
      current_statement__ = 61;
      current_statement__ = 61;
      check_greater_or_equal(function__, "N_obs", N_obs, 1);
      current_statement__ = 62;
      validate_non_negative_index("ii", "N_obs", N_obs);
      current_statement__ = 63;
      context__.validate_dims("data initialization","ii","int",
          context__.to_vec(N_obs));
      ii = std::vector<int>(N_obs, std::numeric_limits<int>::min());
      
      current_statement__ = 63;
      assign(ii, nil_index_list(), context__.vals_i("ii"),
        "assigning variable ii");
      current_statement__ = 63;
      for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
        current_statement__ = 63;
        current_statement__ = 63;
        check_greater_or_equal(function__, "ii[sym1__]", ii[(sym1__ - 1)], 1);
      }
      current_statement__ = 64;
      validate_non_negative_index("jj", "N_obs", N_obs);
      current_statement__ = 65;
      context__.validate_dims("data initialization","jj","int",
          context__.to_vec(N_obs));
      jj = std::vector<int>(N_obs, std::numeric_limits<int>::min());
      
      current_statement__ = 65;
      assign(jj, nil_index_list(), context__.vals_i("jj"),
        "assigning variable jj");
      current_statement__ = 65;
      for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
        current_statement__ = 65;
        current_statement__ = 65;
        check_greater_or_equal(function__, "jj[sym1__]", jj[(sym1__ - 1)], 1);
      }
      current_statement__ = 66;
      context__.validate_dims("data initialization","B","int",
          context__.to_vec());
      B = std::numeric_limits<int>::min();
      
      current_statement__ = 66;
      B = context__.vals_i("B")[(1 - 1)];
      current_statement__ = 66;
      current_statement__ = 66;
      check_greater_or_equal(function__, "B", B, 1);
      current_statement__ = 67;
      context__.validate_dims("data initialization","L","int",
          context__.to_vec());
      L = std::numeric_limits<int>::min();
      
      current_statement__ = 67;
      L = context__.vals_i("L")[(1 - 1)];
      current_statement__ = 67;
      current_statement__ = 67;
      check_greater_or_equal(function__, "L", L, 1);
      current_statement__ = 67;
      current_statement__ = 67;
      check_less_or_equal(function__, "L", L, J);
      current_statement__ = 68;
      context__.validate_dims("data initialization","R","int",
          context__.to_vec());
      R = std::numeric_limits<int>::min();
      
      current_statement__ = 68;
      R = context__.vals_i("R")[(1 - 1)];
      current_statement__ = 68;
      current_statement__ = 68;
      check_greater_or_equal(function__, "R", R, 1);
      current_statement__ = 68;
      current_statement__ = 68;
      check_less_or_equal(function__, "R", R, J);
      current_statement__ = 69;
      validate_non_negative_index("Y", "N_obs", N_obs);
      current_statement__ = 70;
      context__.validate_dims("data initialization","Y","int",
          context__.to_vec(N_obs));
      Y = std::vector<int>(N_obs, std::numeric_limits<int>::min());
      
      current_statement__ = 70;
      assign(Y, nil_index_list(), context__.vals_i("Y"),
        "assigning variable Y");
      current_statement__ = 70;
      for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
        current_statement__ = 70;
        current_statement__ = 70;
        check_greater_or_equal(function__, "Y[sym1__]", Y[(sym1__ - 1)], -B);
      }
      current_statement__ = 70;
      for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
        current_statement__ = 70;
        current_statement__ = 70;
        check_less_or_equal(function__, "Y[sym1__]", Y[(sym1__ - 1)], B);}
      current_statement__ = 71;
      validate_non_negative_index("U", "N_obs", N_obs);
      current_statement__ = 72;
      context__.validate_dims("data initialization","U","double",
          context__.to_vec(N_obs));
      U = std::vector<double>(N_obs, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 72;
      assign(U, nil_index_list(), context__.vals_r("U"),
        "assigning variable U");
      current_statement__ = 72;
      for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
        current_statement__ = 72;
        current_statement__ = 72;
        check_greater_or_equal(function__, "U[sym1__]", U[(sym1__ - 1)], 0);}
      current_statement__ = 72;
      for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
        current_statement__ = 72;
        current_statement__ = 72;
        check_less_or_equal(function__, "U[sym1__]", U[(sym1__ - 1)], 1);}
      current_statement__ = 73;
      validate_non_negative_index("V", "N", N);
      current_statement__ = 74;
      context__.validate_dims("data initialization","V","int",
          context__.to_vec(N));
      V = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 74;
      assign(V, nil_index_list(), context__.vals_i("V"),
        "assigning variable V");
      current_statement__ = 74;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 74;
        current_statement__ = 74;
        check_greater_or_equal(function__, "V[sym1__]", V[(sym1__ - 1)], -B);
      }
      current_statement__ = 74;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 74;
        current_statement__ = 74;
        check_less_or_equal(function__, "V[sym1__]", V[(sym1__ - 1)], B);}
      current_statement__ = 75;
      context__.validate_dims("data initialization","CV","int",
          context__.to_vec());
      CV = std::numeric_limits<int>::min();
      
      current_statement__ = 75;
      CV = context__.vals_i("CV")[(1 - 1)];
      current_statement__ = 75;
      current_statement__ = 75;
      check_greater_or_equal(function__, "CV", CV, 0);
      current_statement__ = 75;
      current_statement__ = 75;
      check_less_or_equal(function__, "CV", CV, 1);
      current_statement__ = 76;
      validate_non_negative_index("holdout", "N_obs", N_obs);
      current_statement__ = 77;
      context__.validate_dims("data initialization","holdout","double",
          context__.to_vec(N_obs));
      holdout = Eigen::Matrix<double, -1, 1>(N_obs);
      stan::math::fill(holdout, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> holdout_flat__;
        current_statement__ = 77;
        assign(holdout_flat__, nil_index_list(), context__.vals_r("holdout"),
          "assigning variable holdout_flat__");
        current_statement__ = 77;
        pos__ = 1;
        current_statement__ = 77;
        for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
          current_statement__ = 77;
          assign(holdout, cons_list(index_uni(sym1__), nil_index_list()),
            holdout_flat__[(pos__ - 1)], "assigning variable holdout");
          current_statement__ = 77;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 77;
      for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
        current_statement__ = 77;
        current_statement__ = 77;
        check_greater_or_equal(function__, "holdout[sym1__]",
                               holdout[(sym1__ - 1)], 0);}
      current_statement__ = 77;
      for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
        current_statement__ = 77;
        current_statement__ = 77;
        check_less_or_equal(function__, "holdout[sym1__]",
                            holdout[(sym1__ - 1)], 1);}
      current_statement__ = 78;
      sigma_alpha_prior_rate = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 78;
      sigma_alpha_prior_rate = ((3 - 1) / (B / 10.0));
      current_statement__ = 79;
      tau_prior_rate = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 79;
      tau_prior_rate = ((2 - 1) / (B / 5.0));
      current_statement__ = 80;
      validate_non_negative_index("not_holdout", "N_obs", N_obs);
      current_statement__ = 81;
      not_holdout = Eigen::Matrix<double, -1, 1>(N_obs);
      stan::math::fill(not_holdout, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 81;
      assign(not_holdout, nil_index_list(), subtract(1, holdout),
        "assigning variable not_holdout");
      current_statement__ = 82;
      validate_non_negative_index("Vvec", "N", N);
      current_statement__ = 83;
      Vvec = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(Vvec, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 83;
      assign(Vvec, nil_index_list(), to_vector(V), "assigning variable Vvec");
      current_statement__ = 84;
      validate_non_negative_index("p", "N_obs", N_obs);
      current_statement__ = 85;
      p = std::vector<std::vector<double>>(2, std::vector<double>(N_obs, std::numeric_limits<double>::quiet_NaN()));
      
      current_statement__ = 89;
      for (int n = 1; n <= N_obs; ++n) {
        current_statement__ = 86;
        assign(p,
          cons_list(index_uni(1), cons_list(index_uni(n), nil_index_list())),
          (((U[(n - 1)] * V[(ii[(n - 1)] - 1)]) + (B * U[(n - 1)])) - B),
          "assigning variable p");
        current_statement__ = 87;
        assign(p,
          cons_list(index_uni(2), cons_list(index_uni(n), nil_index_list())),
          (((U[(n - 1)] * V[(ii[(n - 1)] - 1)]) - (B * U[(n - 1)])) + B),
          "assigning variable p");}
      current_statement__ = 78;
      current_statement__ = 78;
      check_greater_or_equal(function__, "sigma_alpha_prior_rate",
                             sigma_alpha_prior_rate, 0);
      current_statement__ = 79;
      current_statement__ = 79;
      check_greater_or_equal(function__, "tau_prior_rate", tau_prior_rate, 0);
      current_statement__ = 81;
      for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
        current_statement__ = 81;
        current_statement__ = 81;
        check_greater_or_equal(function__, "not_holdout[sym1__]",
                               not_holdout[(sym1__ - 1)], 0);}
      current_statement__ = 81;
      for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
        current_statement__ = 81;
        current_statement__ = 81;
        check_less_or_equal(function__, "not_holdout[sym1__]",
                            not_holdout[(sym1__ - 1)], 1);}
      current_statement__ = 83;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 83;
        current_statement__ = 83;
        check_greater_or_equal(function__, "Vvec[sym1__]",
                               Vvec[(sym1__ - 1)], -B);}
      current_statement__ = 83;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 83;
        current_statement__ = 83;
        check_less_or_equal(function__, "Vvec[sym1__]", Vvec[(sym1__ - 1)], B);
      }
      current_statement__ = 85;
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        current_statement__ = 85;
        for (int sym2__ = 1; sym2__ <= N_obs; ++sym2__) {
          current_statement__ = 85;
          current_statement__ = 85;
          check_greater_or_equal(function__, "p[sym1__, sym2__]",
                                 p[(sym1__ - 1)][(sym2__ - 1)], -B);}}
      current_statement__ = 85;
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        current_statement__ = 85;
        for (int sym2__ = 1; sym2__ <= N_obs; ++sym2__) {
          current_statement__ = 85;
          current_statement__ = 85;
          check_less_or_equal(function__, "p[sym1__, sym2__]",
                              p[(sym1__ - 1)][(sym2__ - 1)], B);}}
      current_statement__ = 90;
      validate_non_negative_index("alpha_raw", "N", N);
      current_statement__ = 91;
      validate_non_negative_index("beta_raw", "N", N);
      current_statement__ = 92;
      validate_non_negative_index("theta_raw", "J", J);
      current_statement__ = 93;
      validate_non_negative_index("logit_lambda", "N", N);
      current_statement__ = 94;
      validate_non_negative_index("gamma", "N", N);
      current_statement__ = 95;
      zeta_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 95;
      zeta_1dim__ = ((2 * B) + 1);
      current_statement__ = 95;
      validate_non_negative_index("zeta", "2 * B + 1", zeta_1dim__);
      current_statement__ = 96;
      validate_non_negative_index("theta", "J", J);
      current_statement__ = 97;
      validate_non_negative_index("alpha0", "N", N);
      current_statement__ = 98;
      validate_non_negative_index("beta0", "N", N);
      current_statement__ = 99;
      validate_non_negative_index("log_lik", "N_obs", N_obs);
      current_statement__ = 100;
      validate_non_negative_index("lambda", "N", N);
      current_statement__ = 101;
      validate_non_negative_index("kappa", "N", N);
      current_statement__ = 102;
      validate_non_negative_index("alpha", "N", N);
      current_statement__ = 103;
      validate_non_negative_index("beta", "N", N);
      current_statement__ = 104;
      validate_non_negative_index("chi", "N", N);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += N * 2;
      num_params_r__ += N * 2;
      num_params_r__ += 2;
      num_params_r__ += J;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += N;
      num_params_r__ += 1;
      num_params_r__ += N;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += zeta_1dim__;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_HBAM_R_MINI_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, -1> alpha_raw;
      alpha_raw = Eigen::Matrix<local_scalar_t__, -1, -1>(N, 2);
      stan::math::fill(alpha_raw, DUMMY_VAR__);
      
      current_statement__ = 1;
      alpha_raw = in__.matrix(N, 2);
      Eigen::Matrix<local_scalar_t__, -1, -1> beta_raw;
      beta_raw = Eigen::Matrix<local_scalar_t__, -1, -1>(N, 2);
      stan::math::fill(beta_raw, DUMMY_VAR__);
      
      current_statement__ = 2;
      beta_raw = in__.matrix(N, 2);
      Eigen::Matrix<local_scalar_t__, -1, 1> theta_lr;
      theta_lr = Eigen::Matrix<local_scalar_t__, -1, 1>(2);
      stan::math::fill(theta_lr, DUMMY_VAR__);
      
      current_statement__ = 3;
      theta_lr = in__.vector(2);
      current_statement__ = 3;
      if (jacobian__) {
        current_statement__ = 3;
        assign(theta_lr, nil_index_list(),
          stan::math::ordered_constrain(theta_lr, lp__),
          "assigning variable theta_lr");
      } else {
        current_statement__ = 3;
        assign(theta_lr, nil_index_list(),
          stan::math::ordered_constrain(theta_lr),
          "assigning variable theta_lr");
      }
      std::vector<local_scalar_t__> theta_raw;
      theta_raw = std::vector<local_scalar_t__>(J, DUMMY_VAR__);
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        current_statement__ = 4;
        assign(theta_raw, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable theta_raw");}
      local_scalar_t__ sigma_alpha;
      sigma_alpha = DUMMY_VAR__;
      
      current_statement__ = 5;
      sigma_alpha = in__.scalar();
      current_statement__ = 5;
      if (jacobian__) {
        current_statement__ = 5;
        sigma_alpha = stan::math::lb_constrain(sigma_alpha, 0, lp__);
      } else {
        current_statement__ = 5;
        sigma_alpha = stan::math::lb_constrain(sigma_alpha, 0);
      }
      local_scalar_t__ sigma_beta;
      sigma_beta = DUMMY_VAR__;
      
      current_statement__ = 6;
      sigma_beta = in__.scalar();
      current_statement__ = 6;
      if (jacobian__) {
        current_statement__ = 6;
        sigma_beta = stan::math::lub_constrain(sigma_beta, 0, 2, lp__);
      } else {
        current_statement__ = 6;
        sigma_beta = stan::math::lub_constrain(sigma_beta, 0, 2);
      }
      local_scalar_t__ tau;
      tau = DUMMY_VAR__;
      
      current_statement__ = 7;
      tau = in__.scalar();
      current_statement__ = 7;
      if (jacobian__) {
        current_statement__ = 7;
        tau = stan::math::lb_constrain(tau, 0, lp__);
      } else {
        current_statement__ = 7;
        tau = stan::math::lb_constrain(tau, 0);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> logit_lambda;
      logit_lambda = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(logit_lambda, DUMMY_VAR__);
      
      current_statement__ = 8;
      logit_lambda = in__.vector(N);
      local_scalar_t__ psi;
      psi = DUMMY_VAR__;
      
      current_statement__ = 9;
      psi = in__.scalar();
      current_statement__ = 9;
      if (jacobian__) {
        current_statement__ = 9;
        psi = stan::math::lb_constrain(psi, 0, lp__);
      } else {
        current_statement__ = 9;
        psi = stan::math::lb_constrain(psi, 0);
      }
      std::vector<local_scalar_t__> gamma;
      gamma = std::vector<local_scalar_t__>(N, DUMMY_VAR__);
      
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 10;
        assign(gamma, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable gamma");}
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 10;
        if (jacobian__) {
          current_statement__ = 10;
          assign(gamma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(gamma[(sym1__ - 1)], 0, 1, lp__),
            "assigning variable gamma");
        } else {
          current_statement__ = 10;
          assign(gamma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(gamma[(sym1__ - 1)], 0, 1),
            "assigning variable gamma");
        }}
      local_scalar_t__ gam_a;
      gam_a = DUMMY_VAR__;
      
      current_statement__ = 11;
      gam_a = in__.scalar();
      current_statement__ = 11;
      if (jacobian__) {
        current_statement__ = 11;
        gam_a = stan::math::lb_constrain(gam_a, 1, lp__);
      } else {
        current_statement__ = 11;
        gam_a = stan::math::lb_constrain(gam_a, 1);
      }
      local_scalar_t__ gam_b;
      gam_b = DUMMY_VAR__;
      
      current_statement__ = 12;
      gam_b = in__.scalar();
      current_statement__ = 12;
      if (jacobian__) {
        current_statement__ = 12;
        gam_b = stan::math::lb_constrain(gam_b, 1, lp__);
      } else {
        current_statement__ = 12;
        gam_b = stan::math::lb_constrain(gam_b, 1);
      }
      Eigen::Matrix<local_scalar_t__, -1, 1> zeta;
      zeta = Eigen::Matrix<local_scalar_t__, -1, 1>(zeta_1dim__);
      stan::math::fill(zeta, DUMMY_VAR__);
      
      current_statement__ = 13;
      zeta = in__.vector(zeta_1dim__);
      current_statement__ = 13;
      for (int sym1__ = 1; sym1__ <= zeta_1dim__; ++sym1__) {
        current_statement__ = 13;
        if (jacobian__) {
          current_statement__ = 13;
          assign(zeta, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(zeta[(sym1__ - 1)], 0, 1, lp__),
            "assigning variable zeta");
        } else {
          current_statement__ = 13;
          assign(zeta, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(zeta[(sym1__ - 1)], 0, 1),
            "assigning variable zeta");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> log_probs;
      log_probs = Eigen::Matrix<local_scalar_t__, -1, 1>(4);
      stan::math::fill(log_probs, DUMMY_VAR__);
      
      std::vector<local_scalar_t__> theta;
      theta = std::vector<local_scalar_t__>(J, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> alpha0;
      alpha0 = Eigen::Matrix<local_scalar_t__, -1, -1>(N, 2);
      stan::math::fill(alpha0, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> beta0;
      beta0 = Eigen::Matrix<local_scalar_t__, -1, -1>(N, 2);
      stan::math::fill(beta0, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> mu0;
      mu0 = Eigen::Matrix<local_scalar_t__, -1, 1>(2);
      stan::math::fill(mu0, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> log_lik;
      log_lik = Eigen::Matrix<local_scalar_t__, -1, 1>(N_obs);
      stan::math::fill(log_lik, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> lambda;
      lambda = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(lambda, DUMMY_VAR__);
      
      current_statement__ = 20;
      assign(lambda, nil_index_list(),
        inv_logit(add(psi, multiply(logit_lambda, 3))),
        "assigning variable lambda");
      current_statement__ = 21;
      assign(theta, nil_index_list(), theta_raw, "assigning variable theta");
      current_statement__ = 22;
      assign(theta, cons_list(index_uni(L), nil_index_list()),
        theta_lr[(1 - 1)], "assigning variable theta");
      current_statement__ = 23;
      assign(theta, cons_list(index_uni(R), nil_index_list()),
        theta_lr[(2 - 1)], "assigning variable theta");
      current_statement__ = 24;
      assign(alpha0,
        cons_list(index_omni(), cons_list(index_uni(1), nil_index_list())),
        multiply(
          rvalue(alpha_raw,
            cons_list(index_omni(),
              cons_list(index_uni(1), nil_index_list())), "alpha_raw"),
          sigma_alpha), "assigning variable alpha0");
      current_statement__ = 25;
      assign(alpha0,
        cons_list(index_omni(), cons_list(index_uni(2), nil_index_list())),
        multiply(
          rvalue(alpha_raw,
            cons_list(index_omni(),
              cons_list(index_uni(2), nil_index_list())), "alpha_raw"),
          sigma_alpha), "assigning variable alpha0");
      current_statement__ = 26;
      assign(beta0,
        cons_list(index_omni(), cons_list(index_uni(1), nil_index_list())),
        stan::math::exp(
          multiply(
            rvalue(beta_raw,
              cons_list(index_omni(),
                cons_list(index_uni(1), nil_index_list())), "beta_raw"),
            sigma_beta)), "assigning variable beta0");
      current_statement__ = 27;
      assign(beta0,
        cons_list(index_omni(), cons_list(index_uni(2), nil_index_list())),
        minus(
          stan::math::exp(
            multiply(
              rvalue(beta_raw,
                cons_list(index_omni(),
                  cons_list(index_uni(2), nil_index_list())), "beta_raw"),
              sigma_beta))), "assigning variable beta0");
      current_statement__ = 36;
      for (int n = 1; n <= N_obs; ++n) {
        current_statement__ = 28;
        assign(mu0, cons_list(index_uni(1), nil_index_list()),
          (rvalue(alpha0,
             cons_list(index_uni(ii[(n - 1)]),
               cons_list(index_uni(1), nil_index_list())), "alpha0") +
            (rvalue(beta0,
               cons_list(index_uni(ii[(n - 1)]),
                 cons_list(index_uni(1), nil_index_list())), "beta0") *
              theta[(jj[(n - 1)] - 1)])), "assigning variable mu0");
        current_statement__ = 29;
        assign(mu0, cons_list(index_uni(2), nil_index_list()),
          (rvalue(alpha0,
             cons_list(index_uni(ii[(n - 1)]),
               cons_list(index_uni(2), nil_index_list())), "alpha0") +
            (rvalue(beta0,
               cons_list(index_uni(ii[(n - 1)]),
                 cons_list(index_uni(2), nil_index_list())), "beta0") *
              theta[(jj[(n - 1)] - 1)])), "assigning variable mu0");
        current_statement__ = 30;
        assign(log_probs, cons_list(index_uni(1), nil_index_list()),
          ((stan::math::log(lambda[(ii[(n - 1)] - 1)]) +
             stan::math::log(zeta[(((V[(ii[(n - 1)] - 1)] + B) + 1) - 1)])) +
            normal_lpdf<false>(Y[(n - 1)],
              (((1 - gamma[(ii[(n - 1)] - 1)]) * mu0[(1 - 1)]) +
                (gamma[(ii[(n - 1)] - 1)] * p[(1 - 1)][(n - 1)])), tau)),
          "assigning variable log_probs");
        current_statement__ = 31;
        assign(log_probs, cons_list(index_uni(2), nil_index_list()),
          ((stan::math::log(lambda[(ii[(n - 1)] - 1)]) +
             stan::math::log(
               (1 - zeta[(((V[(ii[(n - 1)] - 1)] + B) + 1) - 1)]))) +
            normal_lpdf<false>(Y[(n - 1)],
              (((1 - gamma[(ii[(n - 1)] - 1)]) * mu0[(1 - 1)]) +
                (gamma[(ii[(n - 1)] - 1)] * p[(2 - 1)][(n - 1)])), tau)),
          "assigning variable log_probs");
        current_statement__ = 32;
        assign(log_probs, cons_list(index_uni(3), nil_index_list()),
          ((stan::math::log((1 - lambda[(ii[(n - 1)] - 1)])) +
             stan::math::log(zeta[(((V[(ii[(n - 1)] - 1)] + B) + 1) - 1)])) +
            normal_lpdf<false>(Y[(n - 1)],
              (((1 - gamma[(ii[(n - 1)] - 1)]) * mu0[(2 - 1)]) +
                (gamma[(ii[(n - 1)] - 1)] * p[(1 - 1)][(n - 1)])), tau)),
          "assigning variable log_probs");
        current_statement__ = 33;
        assign(log_probs, cons_list(index_uni(4), nil_index_list()),
          ((stan::math::log((1 - lambda[(ii[(n - 1)] - 1)])) +
             stan::math::log(
               (1 - zeta[(((V[(ii[(n - 1)] - 1)] + B) + 1) - 1)]))) +
            normal_lpdf<false>(Y[(n - 1)],
              (((1 - gamma[(ii[(n - 1)] - 1)]) * mu0[(2 - 1)]) +
                (gamma[(ii[(n - 1)] - 1)] * p[(2 - 1)][(n - 1)])), tau)),
          "assigning variable log_probs");
        current_statement__ = 34;
        assign(log_lik, cons_list(index_uni(n), nil_index_list()),
          log_sum_exp(log_probs), "assigning variable log_lik");}
      current_statement__ = 20;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 20;
        current_statement__ = 20;
        check_greater_or_equal(function__, "lambda[sym1__]",
                               lambda[(sym1__ - 1)], 0);}
      current_statement__ = 20;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 20;
        current_statement__ = 20;
        check_less_or_equal(function__, "lambda[sym1__]",
                            lambda[(sym1__ - 1)], 1);}
      {
        current_statement__ = 41;
        lp_accum__.add(normal_lpdf<propto__>(theta_raw, 0, B));
        current_statement__ = 42;
        lp_accum__.add(normal_lpdf<propto__>(theta_lr, 0, B));
        current_statement__ = 43;
        lp_accum__.add(
          normal_lpdf<propto__>(
            rvalue(alpha_raw,
              cons_list(index_omni(),
                cons_list(index_uni(1), nil_index_list())), "alpha_raw"), 0,
            1));
        current_statement__ = 44;
        lp_accum__.add(
          normal_lpdf<propto__>(
            rvalue(alpha_raw,
              cons_list(index_omni(),
                cons_list(index_uni(2), nil_index_list())), "alpha_raw"), 0,
            1));
        current_statement__ = 45;
        lp_accum__.add(
          gamma_lpdf<propto__>(sigma_alpha, 3, sigma_alpha_prior_rate));
        current_statement__ = 46;
        lp_accum__.add(
          normal_lpdf<propto__>(
            rvalue(beta_raw,
              cons_list(index_omni(),
                cons_list(index_uni(1), nil_index_list())), "beta_raw"), 0,
            1));
        current_statement__ = 47;
        lp_accum__.add(
          normal_lpdf<propto__>(
            rvalue(beta_raw,
              cons_list(index_omni(),
                cons_list(index_uni(2), nil_index_list())), "beta_raw"), 0,
            1));
        current_statement__ = 48;
        lp_accum__.add(gamma_lpdf<propto__>(sigma_beta, 9, 40));
        current_statement__ = 49;
        lp_accum__.add(beta_lpdf<propto__>(gamma, gam_a, gam_b));
        current_statement__ = 50;
        lp_accum__.add(gamma_lpdf<propto__>(gam_a, 1.5, .5));
        current_statement__ = 51;
        lp_accum__.add(gamma_lpdf<propto__>(gam_b, 1.5, .5));
        current_statement__ = 52;
        lp_accum__.add(beta_lpdf<propto__>(zeta, 1.2, 1.2));
        current_statement__ = 53;
        lp_accum__.add(gamma_lpdf<propto__>(tau, 2, tau_prior_rate));
        current_statement__ = 54;
        lp_accum__.add(normal_lpdf<propto__>(logit_lambda, 0, 1));
        current_statement__ = 55;
        lp_accum__.add(lognormal_lpdf<propto__>(psi, 1.4, .5));
        current_statement__ = 58;
        if (logical_eq(CV, 0)) {
          current_statement__ = 57;
          lp_accum__.add(sum(log_lik));
        } else {
          current_statement__ = 56;
          lp_accum__.add(sum(elt_multiply(log_lik, not_holdout)));
        }
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_HBAM_R_MINI_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, -1> alpha_raw;
      alpha_raw = Eigen::Matrix<double, -1, -1>(N, 2);
      stan::math::fill(alpha_raw, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      alpha_raw = in__.matrix(N, 2);
      Eigen::Matrix<double, -1, -1> beta_raw;
      beta_raw = Eigen::Matrix<double, -1, -1>(N, 2);
      stan::math::fill(beta_raw, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      beta_raw = in__.matrix(N, 2);
      Eigen::Matrix<double, -1, 1> theta_lr;
      theta_lr = Eigen::Matrix<double, -1, 1>(2);
      stan::math::fill(theta_lr, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      theta_lr = in__.vector(2);
      current_statement__ = 3;
      assign(theta_lr, nil_index_list(),
        stan::math::ordered_constrain(theta_lr),
        "assigning variable theta_lr");
      std::vector<double> theta_raw;
      theta_raw = std::vector<double>(J, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        current_statement__ = 4;
        assign(theta_raw, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable theta_raw");}
      double sigma_alpha;
      sigma_alpha = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      sigma_alpha = in__.scalar();
      current_statement__ = 5;
      sigma_alpha = stan::math::lb_constrain(sigma_alpha, 0);
      double sigma_beta;
      sigma_beta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      sigma_beta = in__.scalar();
      current_statement__ = 6;
      sigma_beta = stan::math::lub_constrain(sigma_beta, 0, 2);
      double tau;
      tau = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      tau = in__.scalar();
      current_statement__ = 7;
      tau = stan::math::lb_constrain(tau, 0);
      Eigen::Matrix<double, -1, 1> logit_lambda;
      logit_lambda = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(logit_lambda, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 8;
      logit_lambda = in__.vector(N);
      double psi;
      psi = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      psi = in__.scalar();
      current_statement__ = 9;
      psi = stan::math::lb_constrain(psi, 0);
      std::vector<double> gamma;
      gamma = std::vector<double>(N, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 10;
        assign(gamma, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable gamma");}
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 10;
        assign(gamma, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_constrain(gamma[(sym1__ - 1)], 0, 1),
          "assigning variable gamma");}
      double gam_a;
      gam_a = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 11;
      gam_a = in__.scalar();
      current_statement__ = 11;
      gam_a = stan::math::lb_constrain(gam_a, 1);
      double gam_b;
      gam_b = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 12;
      gam_b = in__.scalar();
      current_statement__ = 12;
      gam_b = stan::math::lb_constrain(gam_b, 1);
      Eigen::Matrix<double, -1, 1> zeta;
      zeta = Eigen::Matrix<double, -1, 1>(zeta_1dim__);
      stan::math::fill(zeta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 13;
      zeta = in__.vector(zeta_1dim__);
      current_statement__ = 13;
      for (int sym1__ = 1; sym1__ <= zeta_1dim__; ++sym1__) {
        current_statement__ = 13;
        assign(zeta, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_constrain(zeta[(sym1__ - 1)], 0, 1),
          "assigning variable zeta");}
      Eigen::Matrix<double, -1, 1> log_probs;
      log_probs = Eigen::Matrix<double, -1, 1>(4);
      stan::math::fill(log_probs, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<double> theta;
      theta = std::vector<double>(J, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> alpha0;
      alpha0 = Eigen::Matrix<double, -1, -1>(N, 2);
      stan::math::fill(alpha0, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> beta0;
      beta0 = Eigen::Matrix<double, -1, -1>(N, 2);
      stan::math::fill(beta0, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> mu0;
      mu0 = Eigen::Matrix<double, -1, 1>(2);
      stan::math::fill(mu0, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> log_lik;
      log_lik = Eigen::Matrix<double, -1, 1>(N_obs);
      stan::math::fill(log_lik, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> lambda;
      lambda = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(lambda, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          vars__.emplace_back(
            rvalue(alpha_raw,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "alpha_raw"));
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          vars__.emplace_back(
            rvalue(beta_raw,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "beta_raw"));
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        vars__.emplace_back(theta_lr[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        vars__.emplace_back(theta_raw[(sym1__ - 1)]);}
      vars__.emplace_back(sigma_alpha);
      vars__.emplace_back(sigma_beta);
      vars__.emplace_back(tau);
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(logit_lambda[(sym1__ - 1)]);}
      vars__.emplace_back(psi);
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(gamma[(sym1__ - 1)]);}
      vars__.emplace_back(gam_a);
      vars__.emplace_back(gam_b);
      for (int sym1__ = 1; sym1__ <= zeta_1dim__; ++sym1__) {
        vars__.emplace_back(zeta[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 20;
      assign(lambda, nil_index_list(),
        inv_logit(add(psi, multiply(logit_lambda, 3))),
        "assigning variable lambda");
      current_statement__ = 21;
      assign(theta, nil_index_list(), theta_raw, "assigning variable theta");
      current_statement__ = 22;
      assign(theta, cons_list(index_uni(L), nil_index_list()),
        theta_lr[(1 - 1)], "assigning variable theta");
      current_statement__ = 23;
      assign(theta, cons_list(index_uni(R), nil_index_list()),
        theta_lr[(2 - 1)], "assigning variable theta");
      current_statement__ = 24;
      assign(alpha0,
        cons_list(index_omni(), cons_list(index_uni(1), nil_index_list())),
        multiply(
          rvalue(alpha_raw,
            cons_list(index_omni(),
              cons_list(index_uni(1), nil_index_list())), "alpha_raw"),
          sigma_alpha), "assigning variable alpha0");
      current_statement__ = 25;
      assign(alpha0,
        cons_list(index_omni(), cons_list(index_uni(2), nil_index_list())),
        multiply(
          rvalue(alpha_raw,
            cons_list(index_omni(),
              cons_list(index_uni(2), nil_index_list())), "alpha_raw"),
          sigma_alpha), "assigning variable alpha0");
      current_statement__ = 26;
      assign(beta0,
        cons_list(index_omni(), cons_list(index_uni(1), nil_index_list())),
        stan::math::exp(
          multiply(
            rvalue(beta_raw,
              cons_list(index_omni(),
                cons_list(index_uni(1), nil_index_list())), "beta_raw"),
            sigma_beta)), "assigning variable beta0");
      current_statement__ = 27;
      assign(beta0,
        cons_list(index_omni(), cons_list(index_uni(2), nil_index_list())),
        minus(
          stan::math::exp(
            multiply(
              rvalue(beta_raw,
                cons_list(index_omni(),
                  cons_list(index_uni(2), nil_index_list())), "beta_raw"),
              sigma_beta))), "assigning variable beta0");
      current_statement__ = 36;
      for (int n = 1; n <= N_obs; ++n) {
        current_statement__ = 28;
        assign(mu0, cons_list(index_uni(1), nil_index_list()),
          (rvalue(alpha0,
             cons_list(index_uni(ii[(n - 1)]),
               cons_list(index_uni(1), nil_index_list())), "alpha0") +
            (rvalue(beta0,
               cons_list(index_uni(ii[(n - 1)]),
                 cons_list(index_uni(1), nil_index_list())), "beta0") *
              theta[(jj[(n - 1)] - 1)])), "assigning variable mu0");
        current_statement__ = 29;
        assign(mu0, cons_list(index_uni(2), nil_index_list()),
          (rvalue(alpha0,
             cons_list(index_uni(ii[(n - 1)]),
               cons_list(index_uni(2), nil_index_list())), "alpha0") +
            (rvalue(beta0,
               cons_list(index_uni(ii[(n - 1)]),
                 cons_list(index_uni(2), nil_index_list())), "beta0") *
              theta[(jj[(n - 1)] - 1)])), "assigning variable mu0");
        current_statement__ = 30;
        assign(log_probs, cons_list(index_uni(1), nil_index_list()),
          ((stan::math::log(lambda[(ii[(n - 1)] - 1)]) +
             stan::math::log(zeta[(((V[(ii[(n - 1)] - 1)] + B) + 1) - 1)])) +
            normal_lpdf<false>(Y[(n - 1)],
              (((1 - gamma[(ii[(n - 1)] - 1)]) * mu0[(1 - 1)]) +
                (gamma[(ii[(n - 1)] - 1)] * p[(1 - 1)][(n - 1)])), tau)),
          "assigning variable log_probs");
        current_statement__ = 31;
        assign(log_probs, cons_list(index_uni(2), nil_index_list()),
          ((stan::math::log(lambda[(ii[(n - 1)] - 1)]) +
             stan::math::log(
               (1 - zeta[(((V[(ii[(n - 1)] - 1)] + B) + 1) - 1)]))) +
            normal_lpdf<false>(Y[(n - 1)],
              (((1 - gamma[(ii[(n - 1)] - 1)]) * mu0[(1 - 1)]) +
                (gamma[(ii[(n - 1)] - 1)] * p[(2 - 1)][(n - 1)])), tau)),
          "assigning variable log_probs");
        current_statement__ = 32;
        assign(log_probs, cons_list(index_uni(3), nil_index_list()),
          ((stan::math::log((1 - lambda[(ii[(n - 1)] - 1)])) +
             stan::math::log(zeta[(((V[(ii[(n - 1)] - 1)] + B) + 1) - 1)])) +
            normal_lpdf<false>(Y[(n - 1)],
              (((1 - gamma[(ii[(n - 1)] - 1)]) * mu0[(2 - 1)]) +
                (gamma[(ii[(n - 1)] - 1)] * p[(1 - 1)][(n - 1)])), tau)),
          "assigning variable log_probs");
        current_statement__ = 33;
        assign(log_probs, cons_list(index_uni(4), nil_index_list()),
          ((stan::math::log((1 - lambda[(ii[(n - 1)] - 1)])) +
             stan::math::log(
               (1 - zeta[(((V[(ii[(n - 1)] - 1)] + B) + 1) - 1)]))) +
            normal_lpdf<false>(Y[(n - 1)],
              (((1 - gamma[(ii[(n - 1)] - 1)]) * mu0[(2 - 1)]) +
                (gamma[(ii[(n - 1)] - 1)] * p[(2 - 1)][(n - 1)])), tau)),
          "assigning variable log_probs");
        current_statement__ = 34;
        assign(log_lik, cons_list(index_uni(n), nil_index_list()),
          log_sum_exp(log_probs), "assigning variable log_lik");}
      current_statement__ = 20;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 20;
        current_statement__ = 20;
        check_greater_or_equal(function__, "lambda[sym1__]",
                               lambda[(sym1__ - 1)], 0);}
      current_statement__ = 20;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 20;
        current_statement__ = 20;
        check_less_or_equal(function__, "lambda[sym1__]",
                            lambda[(sym1__ - 1)], 1);}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= 4; ++sym1__) {
          vars__.emplace_back(log_probs[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
          vars__.emplace_back(theta[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            vars__.emplace_back(
              rvalue(alpha0,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "alpha0"));
          }}
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            vars__.emplace_back(
              rvalue(beta0,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())), "beta0"));
          }}
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          vars__.emplace_back(mu0[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
          vars__.emplace_back(log_lik[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(lambda[(sym1__ - 1)]);}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, 1> kappa;
      kappa = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(kappa, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 37;
      assign(kappa, nil_index_list(),
        to_vector(bernoulli_rng(lambda, base_rng__)),
        "assigning variable kappa");
      Eigen::Matrix<double, -1, 1> alpha;
      alpha = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(alpha, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 38;
      assign(alpha, nil_index_list(),
        add(
          elt_multiply(kappa,
            rvalue(alpha0,
              cons_list(index_omni(),
                cons_list(index_uni(1), nil_index_list())), "alpha0")),
          elt_multiply(subtract(1, kappa),
            rvalue(alpha0,
              cons_list(index_omni(),
                cons_list(index_uni(2), nil_index_list())), "alpha0"))),
        "assigning variable alpha");
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 39;
      assign(beta, nil_index_list(),
        add(
          elt_multiply(kappa,
            rvalue(beta0,
              cons_list(index_omni(),
                cons_list(index_uni(1), nil_index_list())), "beta0")),
          elt_multiply(subtract(1, kappa),
            rvalue(beta0,
              cons_list(index_omni(),
                cons_list(index_uni(2), nil_index_list())), "beta0"))),
        "assigning variable beta");
      Eigen::Matrix<double, -1, 1> chi;
      chi = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(chi, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 40;
      assign(chi, nil_index_list(),
        elt_divide(
          subtract(
            subtract(Vvec,
              to_vector(normal_rng(0, rep_vector(tau, N), base_rng__))),
            alpha), beta), "assigning variable chi");
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(kappa[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(alpha[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(chi[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, -1> alpha_raw;
      alpha_raw = Eigen::Matrix<double, -1, -1>(N, 2);
      stan::math::fill(alpha_raw, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> alpha_raw_flat__;
        current_statement__ = 1;
        assign(alpha_raw_flat__, nil_index_list(),
          context__.vals_r("alpha_raw"),
          "assigning variable alpha_raw_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          current_statement__ = 1;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 1;
            assign(alpha_raw,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              alpha_raw_flat__[(pos__ - 1)], "assigning variable alpha_raw");
            current_statement__ = 1;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, -1> beta_raw;
      beta_raw = Eigen::Matrix<double, -1, -1>(N, 2);
      stan::math::fill(beta_raw, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_raw_flat__;
        current_statement__ = 2;
        assign(beta_raw_flat__, nil_index_list(),
          context__.vals_r("beta_raw"), "assigning variable beta_raw_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 2;
            assign(beta_raw,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              beta_raw_flat__[(pos__ - 1)], "assigning variable beta_raw");
            current_statement__ = 2;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, 1> theta_lr;
      theta_lr = Eigen::Matrix<double, -1, 1>(2);
      stan::math::fill(theta_lr, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> theta_lr_flat__;
        current_statement__ = 3;
        assign(theta_lr_flat__, nil_index_list(),
          context__.vals_r("theta_lr"), "assigning variable theta_lr_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
          current_statement__ = 3;
          assign(theta_lr, cons_list(index_uni(sym1__), nil_index_list()),
            theta_lr_flat__[(pos__ - 1)], "assigning variable theta_lr");
          current_statement__ = 3;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> theta_lr_free__;
      theta_lr_free__ = Eigen::Matrix<double, -1, 1>(2);
      stan::math::fill(theta_lr_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      assign(theta_lr_free__, nil_index_list(),
        stan::math::ordered_free(theta_lr),
        "assigning variable theta_lr_free__");
      std::vector<double> theta_raw;
      theta_raw = std::vector<double>(J, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      assign(theta_raw, nil_index_list(), context__.vals_r("theta_raw"),
        "assigning variable theta_raw");
      double sigma_alpha;
      sigma_alpha = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      sigma_alpha = context__.vals_r("sigma_alpha")[(1 - 1)];
      double sigma_alpha_free__;
      sigma_alpha_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      sigma_alpha_free__ = stan::math::lb_free(sigma_alpha, 0);
      double sigma_beta;
      sigma_beta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      sigma_beta = context__.vals_r("sigma_beta")[(1 - 1)];
      double sigma_beta_free__;
      sigma_beta_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      sigma_beta_free__ = stan::math::lub_free(sigma_beta, 0, 2);
      double tau;
      tau = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      tau = context__.vals_r("tau")[(1 - 1)];
      double tau_free__;
      tau_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      tau_free__ = stan::math::lb_free(tau, 0);
      Eigen::Matrix<double, -1, 1> logit_lambda;
      logit_lambda = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(logit_lambda, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> logit_lambda_flat__;
        current_statement__ = 8;
        assign(logit_lambda_flat__, nil_index_list(),
          context__.vals_r("logit_lambda"),
          "assigning variable logit_lambda_flat__");
        current_statement__ = 8;
        pos__ = 1;
        current_statement__ = 8;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 8;
          assign(logit_lambda,
            cons_list(index_uni(sym1__), nil_index_list()),
            logit_lambda_flat__[(pos__ - 1)],
            "assigning variable logit_lambda");
          current_statement__ = 8;
          pos__ = (pos__ + 1);}
      }
      double psi;
      psi = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      psi = context__.vals_r("psi")[(1 - 1)];
      double psi_free__;
      psi_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      psi_free__ = stan::math::lb_free(psi, 0);
      std::vector<double> gamma;
      gamma = std::vector<double>(N, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 10;
      assign(gamma, nil_index_list(), context__.vals_r("gamma"),
        "assigning variable gamma");
      std::vector<double> gamma_free__;
      gamma_free__ = std::vector<double>(N, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 10;
        assign(gamma_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_free(gamma[(sym1__ - 1)], 0, 1),
          "assigning variable gamma_free__");}
      double gam_a;
      gam_a = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 11;
      gam_a = context__.vals_r("gam_a")[(1 - 1)];
      double gam_a_free__;
      gam_a_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 11;
      gam_a_free__ = stan::math::lb_free(gam_a, 1);
      double gam_b;
      gam_b = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 12;
      gam_b = context__.vals_r("gam_b")[(1 - 1)];
      double gam_b_free__;
      gam_b_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 12;
      gam_b_free__ = stan::math::lb_free(gam_b, 1);
      Eigen::Matrix<double, -1, 1> zeta;
      zeta = Eigen::Matrix<double, -1, 1>(zeta_1dim__);
      stan::math::fill(zeta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> zeta_flat__;
        current_statement__ = 13;
        assign(zeta_flat__, nil_index_list(), context__.vals_r("zeta"),
          "assigning variable zeta_flat__");
        current_statement__ = 13;
        pos__ = 1;
        current_statement__ = 13;
        for (int sym1__ = 1; sym1__ <= zeta_1dim__; ++sym1__) {
          current_statement__ = 13;
          assign(zeta, cons_list(index_uni(sym1__), nil_index_list()),
            zeta_flat__[(pos__ - 1)], "assigning variable zeta");
          current_statement__ = 13;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> zeta_free__;
      zeta_free__ = Eigen::Matrix<double, -1, 1>(zeta_1dim__);
      stan::math::fill(zeta_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 13;
      for (int sym1__ = 1; sym1__ <= zeta_1dim__; ++sym1__) {
        current_statement__ = 13;
        assign(zeta_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_free(zeta[(sym1__ - 1)], 0, 1),
          "assigning variable zeta_free__");}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          vars__.emplace_back(
            rvalue(alpha_raw,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "alpha_raw"));
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          vars__.emplace_back(
            rvalue(beta_raw,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())), "beta_raw"));
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        vars__.emplace_back(theta_lr_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        vars__.emplace_back(theta_raw[(sym1__ - 1)]);}
      vars__.emplace_back(sigma_alpha_free__);
      vars__.emplace_back(sigma_beta_free__);
      vars__.emplace_back(tau_free__);
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(logit_lambda[(sym1__ - 1)]);}
      vars__.emplace_back(psi_free__);
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(gamma_free__[(sym1__ - 1)]);}
      vars__.emplace_back(gam_a_free__);
      vars__.emplace_back(gam_b_free__);
      for (int sym1__ = 1; sym1__ <= zeta_1dim__; ++sym1__) {
        vars__.emplace_back(zeta_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("alpha_raw");
    names__.emplace_back("beta_raw");
    names__.emplace_back("theta_lr");
    names__.emplace_back("theta_raw");
    names__.emplace_back("sigma_alpha");
    names__.emplace_back("sigma_beta");
    names__.emplace_back("tau");
    names__.emplace_back("logit_lambda");
    names__.emplace_back("psi");
    names__.emplace_back("gamma");
    names__.emplace_back("gam_a");
    names__.emplace_back("gam_b");
    names__.emplace_back("zeta");
    names__.emplace_back("log_probs");
    names__.emplace_back("theta");
    names__.emplace_back("alpha0");
    names__.emplace_back("beta0");
    names__.emplace_back("mu0");
    names__.emplace_back("log_lik");
    names__.emplace_back("lambda");
    names__.emplace_back("kappa");
    names__.emplace_back("alpha");
    names__.emplace_back("beta");
    names__.emplace_back("chi");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N),
                                             static_cast<size_t>(2)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N),
                                             static_cast<size_t>(2)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(2)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(J)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(zeta_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(4)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(J)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N),
                                             static_cast<size_t>(2)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N),
                                             static_cast<size_t>(2)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(2)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_obs)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "alpha_raw" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "beta_raw" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "theta_lr" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "theta_raw" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "sigma_alpha");
    param_names__.emplace_back(std::string() + "sigma_beta");
    param_names__.emplace_back(std::string() + "tau");
    for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "logit_lambda" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "psi");
    for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gamma" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "gam_a");
    param_names__.emplace_back(std::string() + "gam_b");
    for (int sym1__ = 1; sym1__ <= zeta_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "zeta" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= 4; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_probs" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "alpha0" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "beta0" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "mu0" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "lambda" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "kappa" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "chi" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "alpha_raw" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "beta_raw" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "theta_lr" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "theta_raw" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "sigma_alpha");
    param_names__.emplace_back(std::string() + "sigma_beta");
    param_names__.emplace_back(std::string() + "tau");
    for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "logit_lambda" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "psi");
    for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gamma" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "gam_a");
    param_names__.emplace_back(std::string() + "gam_b");
    for (int sym1__ = 1; sym1__ <= zeta_1dim__; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "zeta" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= 4; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_probs" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= J; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "theta" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "alpha0" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "beta0" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= 2; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "mu0" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_obs; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "lambda" + '.' + std::to_string(sym1__));
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "kappa" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "chi" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"alpha_raw\",\"type\":{\"name\":\"matrix\",\"rows\":" << N << ",\"cols\":" << 2 << "},\"block\":\"parameters\"},{\"name\":\"beta_raw\",\"type\":{\"name\":\"matrix\",\"rows\":" << N << ",\"cols\":" << 2 << "},\"block\":\"parameters\"},{\"name\":\"theta_lr\",\"type\":{\"name\":\"vector\",\"length\":" << 2 << "},\"block\":\"parameters\"},{\"name\":\"theta_raw\",\"type\":{\"name\":\"array\",\"length\":" << J << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_alpha\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_beta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"logit_lambda\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"parameters\"},{\"name\":\"psi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"gamma\",\"type\":{\"name\":\"array\",\"length\":" << N << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"gam_a\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"gam_b\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"zeta\",\"type\":{\"name\":\"vector\",\"length\":" << zeta_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"log_probs\",\"type\":{\"name\":\"vector\",\"length\":" << 4 << "},\"block\":\"transformed_parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"array\",\"length\":" << J << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"alpha0\",\"type\":{\"name\":\"matrix\",\"rows\":" << N << ",\"cols\":" << 2 << "},\"block\":\"transformed_parameters\"},{\"name\":\"beta0\",\"type\":{\"name\":\"matrix\",\"rows\":" << N << ",\"cols\":" << 2 << "},\"block\":\"transformed_parameters\"},{\"name\":\"mu0\",\"type\":{\"name\":\"vector\",\"length\":" << 2 << "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << N_obs << "},\"block\":\"transformed_parameters\"},{\"name\":\"lambda\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"kappa\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"},{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"},{\"name\":\"chi\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"alpha_raw\",\"type\":{\"name\":\"matrix\",\"rows\":" << N << ",\"cols\":" << 2 << "},\"block\":\"parameters\"},{\"name\":\"beta_raw\",\"type\":{\"name\":\"matrix\",\"rows\":" << N << ",\"cols\":" << 2 << "},\"block\":\"parameters\"},{\"name\":\"theta_lr\",\"type\":{\"name\":\"vector\",\"length\":" << 2 << "},\"block\":\"parameters\"},{\"name\":\"theta_raw\",\"type\":{\"name\":\"array\",\"length\":" << J << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma_alpha\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_beta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"logit_lambda\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"parameters\"},{\"name\":\"psi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"gamma\",\"type\":{\"name\":\"array\",\"length\":" << N << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"gam_a\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"gam_b\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"zeta\",\"type\":{\"name\":\"vector\",\"length\":" << zeta_1dim__ << "},\"block\":\"parameters\"},{\"name\":\"log_probs\",\"type\":{\"name\":\"vector\",\"length\":" << 4 << "},\"block\":\"transformed_parameters\"},{\"name\":\"theta\",\"type\":{\"name\":\"array\",\"length\":" << J << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"alpha0\",\"type\":{\"name\":\"matrix\",\"rows\":" << N << ",\"cols\":" << 2 << "},\"block\":\"transformed_parameters\"},{\"name\":\"beta0\",\"type\":{\"name\":\"matrix\",\"rows\":" << N << ",\"cols\":" << 2 << "},\"block\":\"transformed_parameters\"},{\"name\":\"mu0\",\"type\":{\"name\":\"vector\",\"length\":" << 2 << "},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << N_obs << "},\"block\":\"transformed_parameters\"},{\"name\":\"lambda\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"kappa\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"},{\"name\":\"alpha\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"},{\"name\":\"chi\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_HBAM_R_MINI_namespace::model_HBAM_R_MINI;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_HBAM_R_MINI_namespace::profiles__;
}
#endif
#endif
