% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sizeWR.R
\name{sizeWR}
\alias{sizeWR}
\title{Sample size calculation for the win ratio test (with WR = 1 null hypothesis)}
\usage{
sizeWR(WR, power, WO = NULL, Pties = NULL, k = 0.5, alpha = 0.05)
}
\arguments{
\item{WR}{a numeric vector of win odds values.}

\item{power}{the given power. A numeric vector of length 1.}

\item{WO}{win odds. Should be specified only if \code{Pties} is not specified. A numeric vector of length 1.}

\item{Pties}{probability of ties. A numeric vector of length 1.}

\item{k}{proportion of active group in the overall sample size. Default is 0.5 (balanced randomization). A numeric vector of length 1.}

\item{alpha}{the significance level for the 2-sided test. Default is 0.05. A numeric vector of length 1.}
}
\value{
a data frame containing the sample size with input values.
}
\description{
Sample size calculation for the win ratio test (with WR = 1 null hypothesis)
}
\examples{
sizeWR(WR = 1.36, Pties = 0.064, power = 0.9)
sizeWR(WR = 1.36, WO = 1.333, power = 0.9)
}
\references{
Yu RX, Ganju J. (2022) "Sample size formula for a win ratio endpoint." Statistics in Medicine, 41.6: 950-63. \url{doi:10.1002/sim.9297}.
}
\seealso{
\code{\link[=sizeWO]{sizeWO()}} for WO sample size calculation.
}
