% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_post.R
\name{glm.post}
\alias{glm.post}
\title{Posterior of a normal/half-normal prior}
\usage{
glm.post(
  formula,
  family,
  data.list,
  offset.list = NULL,
  beta.mean = NULL,
  beta.sd = NULL,
  disp.mean = NULL,
  disp.sd = NULL,
  iter_warmup = 1000,
  iter_sampling = 1000,
  chains = 4,
  ...
)
}
\arguments{
\item{formula}{a two-sided formula giving the relationship between the response variable and covariates.}

\item{family}{an object of class \code{family}. See \code{\link[stats:family]{?stats::family}}.}

\item{data.list}{a list consisting of one \code{data.frame} giving the current data. If \code{data.list} has more
than one \code{data.frame}, only the first element will be used as the current data.}

\item{offset.list}{a list consisting of one vector giving the offset for the current data. The length of
the vector is equal to the number of rows in the current data. The vector has all values
set to 0 by default. If \code{offset.list} has more than one vector, same as for \code{data.list}.}

\item{beta.mean}{a scalar or a vector whose dimension is equal to the number of regression coefficients giving
the mean parameters for the normal prior on regression coefficients. If a scalar is provided,
\code{beta.mean} will be a vector of repeated elements of the given scalar. Defaults to a vector of 0s.}

\item{beta.sd}{a scalar or a vector whose dimension is equal to the number of regression coefficients giving
the sd parameters for the normal prior on regression coefficients. If a scalar is provided,
same as for \code{beta.mean}. Defaults to a vector of 10s.}

\item{disp.mean}{location parameter for the half-normal prior on dispersion parameter. Defaults to 0. If
\code{disp.mean} is a vector with length > 1, only the first element will be used as \code{disp.mean}.}

\item{disp.sd}{scale parameter for the half-normal prior on dispersion parameter. Defaults to 10. If
\code{disp.sd} is a vector with length > 1, same as for \code{disp.mean}.}

\item{iter_warmup}{number of warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_warmup} in
\code{sample()} method in cmdstanr package.}

\item{iter_sampling}{number of post-warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_sampling}
in \code{sample()} method in cmdstanr package.}

\item{chains}{number of Markov chains to run. Defaults to 4. See the argument \code{chains} in \code{sample()} method in
cmdstanr package.}

\item{...}{arguments passed to \code{sample()} method in cmdstanr package (e.g., \code{seed}, \code{refresh}, \code{init}).}
}
\value{
The function returns an object of class \code{draws_df} giving posterior samples, with an attribute called 'data' which includes
the list of variables specified in the data block of the Stan program.
}
\description{
Sample from the posterior distribution of a GLM using a normal/half-normal prior.
}
\details{
The priors on the regression coefficients are independent normal distributions. When the normal priors are elicited
with large variances, the prior is also referred to as the reference or vague prior. The dispersion parameter is
assumed to be independent of the regression coefficients with a half-normal prior (if applicable).
}
\examples{
if (instantiate::stan_cmdstan_exists()) {
  data(actg019)
  ## take subset for speed purposes
  actg019 = actg019[1:100, ]
  data.list = list(currdata = actg019)
  glm.post(
    formula = cd4 ~ treatment + age + race,
    family = poisson('log'),
    data.list = data.list,
    beta.sd   = 10,
    chains = 1, iter_warmup = 500, iter_sampling = 1000
  )
}
}
