% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MOPEX.R
\name{tsMOPEX}
\alias{tsMOPEX}
\title{Interface for the MOPEX database of Daily Time Series}
\usage{
tsMOPEX(id, MAP = TRUE)
}
\arguments{
\item{id}{String for the station ID number (USGS_ID)}

\item{MAP}{Boolean, TRUE by default. If FALSE it looks for data through all
the 1861 potential MOPEX basins.
If TRUE, it looks for data through the 438 MOPEX basins with MAP estimates.}
}
\value{
If MAP = FALSE, this function returns a time series of daily
streamflow discharge (Q, in mm). If MAP = TRUE, this function returns a data
frame containing the following columns (as zoo object):
\describe{
  \item{\code{Date}}{Format is "yyyymmdd"}
  \item{\code{P}}{Mean areal precipitation (mm)}
  \item{\code{E}}{Climatic potential evaporation (mm, based NOAA Freewater Evaporation Atlas)}
  \item{\code{Q}}{Daily streamflow discharge (mm)}
  \item{\code{T_max}}{Daily maximum air temperature (Celsius)}
  \item{\code{T_min}}{Daily minimum air temperature (Celsius)}
}
}
\description{
This function extract the dataset containing daily rainfall and
streamflow discharge at one of the MOPEX locations.
}
\examples{
\dontrun{
  BroadRiver <- tsMOPEX(id = "01048000")
}

}
\author{
Claudia Vitolo
}
