// (c) The HDF Group
#ifndef H5FDmpio_H
#define H5FDmpio_H
#ifdef H5_HAVE_PARALLEL
#define H5FD_MPIO (H5FDperform_init(H5FD_mpio_init))
#else
#define H5FD_MPIO (H5I_INVALID_HID)
#endif
#ifdef H5_HAVE_PARALLEL
#if defined(H5F_DEBUG) && !defined(H5FDmpio_DEBUG)
#define H5FDmpio_DEBUG
#endif
H5_DLLVAR hbool_t H5FD_mpi_opt_types_g;
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL hid_t H5FD_mpio_init(void);
H5_DLL herr_t H5Pset_fapl_mpio(hid_t fapl_id, MPI_Comm comm, MPI_Info info);
H5_DLL herr_t H5Pget_fapl_mpio(hid_t fapl_id, MPI_Comm *comm, MPI_Info *info);
H5_DLL herr_t H5Pset_dxpl_mpio(hid_t dxpl_id, H5FD_mpio_xfer_t xfer_mode);
H5_DLL herr_t H5Pget_dxpl_mpio(hid_t dxpl_id, H5FD_mpio_xfer_t *xfer_mode);
H5_DLL herr_t H5Pset_dxpl_mpio_collective_opt(hid_t dxpl_id, H5FD_mpio_collective_opt_t opt_mode);
H5_DLL herr_t H5Pset_dxpl_mpio_chunk_opt(hid_t dxpl_id, H5FD_mpio_chunk_opt_t opt_mode);
H5_DLL herr_t H5Pset_dxpl_mpio_chunk_opt_num(hid_t dxpl_id, unsigned num_chunk_per_proc);
H5_DLL herr_t H5Pset_dxpl_mpio_chunk_opt_ratio(hid_t dxpl_id, unsigned percent_num_proc_per_chunk);
#ifdef __cplusplus
}
#endif
#endif
#endif
